class SublimeText
{
  public void open()
  {
    System.out.println("Sublime Text is Opened");
  }

  public void edit()
  {
    System.out.println("Sublime Text is Edited");
  }

  public void save()
  {
    System.out.println("Sublime Text is Saved");
  }

  public void close()
  {
    System.out.println("Sublime Text is Closed");
  }

}

interface Command
{
  public void execute();
}

class OpenSublimeText implements Command
{
  private SublimeText sublimeText;

  public OpenSublimeText( SublimeText sublimeText )
  {
    this.sublimeText = sublimeText;
  }

  @Override
  public void execute()
  {
    sublimeText.open();
  }
}

class EditSublimeText implements Command
{
  private SublimeText sublimeText;

  public EditSublimeText( SublimeText sublimeText )
  {
    this.sublimeText = sublimeText;
  }

  @Override
  public void execute()
  {
    sublimeText.edit();
  }
}

class SaveSublimeText implements Command
{
  private SublimeText sublimeText;

  public SaveSublimeText( SublimeText sublimeText )
  {
    this.sublimeText = sublimeText;
  }

  @Override
  public void execute()
  {
    sublimeText.save();
  }
}

class CloseSublimeText implements Command
{
  private SublimeText sublimeText;

  public CloseSublimeText( SublimeText sublimeText )
  {
    this.sublimeText = sublimeText;
  }

  @Override
  public void execute()
  {
    sublimeText.close();
  }
}

class Options
{
  private Command openSublimeText;
  private Command editSublimeText;
  private Command saveSublimeText;
  private Command closeSublimeText;

  public Options( Command open, Command edit, Command save, Command close )
  {
    this.openSublimeText = open;
    this.editSublimeText = edit;
    this.saveSublimeText = save;
    this.closeSublimeText = close;
  }

  public void pressOpen()
  {
    openSublimeText.execute();
  }

  public void pressEdit()
  {
    editSublimeText.execute();
  }

  public void pressSave()
  {
    saveSublimeText.execute();
  }

  public void pressClose()
  {
    closeSublimeText.execute();
  }
  
}  
public class CommandDesignPattern {
	  public static void main( String[] args )
	  {
	    SublimeText sublimeText = new SublimeText();
	    Command openSublimeText = new OpenSublimeText(sublimeText);
	    Command editSublimeText = new EditSublimeText(sublimeText);
	    Command saveSublimeText = new SaveSublimeText(sublimeText);
	    Command closeSublimeText = new CloseSublimeText(sublimeText);
	    Options option = new Options(openSublimeText,editSublimeText, saveSublimeText,closeSublimeText);
	    option.pressOpen();
	    option.pressEdit();
	    option.pressSave();
	    option.pressClose();
	  }
}
