import java.util.Date;
import java.util.ArrayList;
import java.util.Scanner;

class Format
{
  public Format format;
  public Date date;

  public Format getFormat()
  {
    return format;
  }

  public void setFormat( Format format2 )
  {
    this.format = format2;
  }

  public Date getDate()
  {
    return date;
  }

  public void setDate( Date date )
  {
    this.date = date;
  }

  public String replaceAll(String string, String string2) {
		// TODO Auto-generated method stub
		return null;
	}

	public String[] split(String string) {
		// TODO Auto-generated method stub
		return null;
	}

	public void setFormat(String tempFormat) {
		// TODO Auto-generated method stub
		
	}

}

abstract class AbstractFormat
{
  public abstract void execute( Format format);
}

class DayFormat extends AbstractFormat
{

  @Override
  public void execute( Format format )
  {
    Format format2 = format.getFormat();
    Date date = format.getDate();
    @SuppressWarnings("deprecation")
	Integer day = new Integer(date.getDate());
    String tempFormat = format2.replaceAll("DD", day.toString());
    format2.setFormat(tempFormat);
  }
} 

class MonthFormat extends AbstractFormat
{

  @Override
  public void execute( Format format )
  {
    Format format1 = format.getFormat();
    Date date = format.getDate();
    @SuppressWarnings("deprecation")
	Integer month = new Integer(date.getMonth()+1);
    String tempFormat = format1.replaceAll("MM", month.toString());
    format.setFormat(tempFormat);
  }
} 

class YearFormat extends AbstractFormat
{

  @Override
  public void execute( Format format )
  {
    Format format1 = format.getFormat();
    Date date = format.getDate();
    @SuppressWarnings("deprecation")
	Integer year = new Integer(date.getYear() + 2000);
    String tempFormat = format1.replaceAll("YYYY", year.toString());
    format.setFormat(tempFormat);
  }
} 



public class InterpreterDesignPattern {
	private static Scanner scanner;
	private static String inputDate;

	public static void main( String[] args )
	  {

	    System.out.println("Please select the Date Format: 'MM-DD-YYYY' or 'YYYY-MM-DD' or 'DD-MM-YYYY' ");
	    scanner = new Scanner(System.in);
	    setInputDate(scanner.next());

	    Format format = new Format();
	    format.setFormat(format);
	    format.setDate(new Date());

	    ArrayList<AbstractFormat> formatOrderList = getFormatOrder(format);

	    System.out.println("Input : " + format.getFormat() + " : " + new Date());

	    for( AbstractFormat abstractFormat : formatOrderList )
	    {
	      abstractFormat.execute(format);
	      System.out.println(abstractFormat.getClass().getName() + " Executed: " + format.getFormat());

	    }

	    System.out.println("Output : " + format.getFormat());
	  }

	  private static ArrayList<AbstractFormat> getFormatOrder( Format format)
	  {
	    ArrayList<AbstractFormat> formatOrderList = new ArrayList<AbstractFormat>();
	    String[] strArray = format.getFormat().split("-");
	    for( String string : strArray )
	    {
	      if( string.equalsIgnoreCase("MM") )
	      {
	        formatOrderList.add(new MonthFormat());
	      }
	      else if( string.equalsIgnoreCase("DD") )
	      {
	        formatOrderList.add(new DayFormat());
	      }
	      else
	      {
	        formatOrderList.add(new YearFormat());
	      }

	    }
	    return formatOrderList;
	  }

	public static String getInputDate() {
		return inputDate;
	}

	public static void setInputDate(String inputDate) {
		InterpreterDesignPattern.inputDate = inputDate;
	}
}
