package com.javacodegeeks.examples;

import static org.junit.Assert.assertTrue;

import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpRequest.BodyPublishers;
import java.net.http.HttpResponse;
import java.net.http.HttpResponse.BodyHandlers;
import java.nio.file.Path;
import java.nio.file.Paths;

import org.junit.Test;

public class HttpClientApiTest {

	private final String url = "http://localhost:8080/students";
	private final String s_json = "{\"firstName\":\"Jason\",\"lastName\":\"Bourne\",\"year\":\"Sophomore\"}";

	@Test
	public void get() throws Exception {
		HttpClient client = HttpClient.newHttpClient();
		HttpRequest request = HttpRequest.newBuilder()
				.uri(URI.create(url))
				.build();

		HttpResponse<String> response = client.send(request, BodyHandlers.ofString());

		System.out.println(response.statusCode());
		System.out.println(response.headers());
		System.out.println(response.body());
		assertTrue("Status Code is not OK", response.statusCode() == 200);
	}
	
	@Test
	public void getSingle() throws Exception {
		HttpClient client = HttpClient.newHttpClient();
		HttpRequest request = HttpRequest.newBuilder()
				.uri(URI.create(
						new StringBuilder(url).append("/102").toString()))
				.build();
		
		HttpResponse<Path> response = client.send(
				request, BodyHandlers.ofFile(Paths.get("src", "test", "resources", "student-102.json")));
		assertTrue("Status Code is not OK", response.statusCode() == 200);
	}
	
	@Test
	public void post() throws Exception {
		HttpClient client = HttpClient.newHttpClient();
		HttpRequest request = HttpRequest.newBuilder()
				.uri(URI.create(url))
				.header("Content-Type", "application/json")
				.POST(BodyPublishers.ofString(s_json))
				.build();

		HttpResponse<?> response = client.send(request, BodyHandlers.discarding());
		assertTrue("Status Code is not Created", response.statusCode() == 201);
	}

	@Test
	public void postAsync() throws Exception {
		HttpClient client = HttpClient.newHttpClient();
		HttpRequest request = HttpRequest.newBuilder()
				.uri(URI.create(url))
				.header("Content-Type", "application/json")
				.POST(BodyPublishers.ofFile(Paths.get("src", "test", "resources", "gates.json"))).build();

		client.sendAsync(request, BodyHandlers.ofString())
				.thenApply(HttpResponse::statusCode)
				.thenAccept(statusCode -> assertTrue("Status Code is not Created", statusCode == 201));
	}
	
}
