package org.jcg.zheng;

import java.util.Arrays;

public abstract class RandomIntegerBase {

    protected int boundary = 10;
    protected int origin = 0;
    protected int streamSize = 5;

    protected abstract int getRandomInteger(SignatureType signatureType);

    protected abstract int[] getRandomInts(SignatureType methodSignature);

    protected abstract SignatureType[] getNextIntSignatures();

    protected abstract SignatureType[] getIntsSignatures();

    protected void randomInteger() {
        for (SignatureType methodSignature : getNextIntSignatures()) {
            System.out.println("\n\twith signature: " + methodSignature.name());
            for (int i = origin; i < boundary; i++) {
                System.out.print(getRandomInteger(methodSignature) + "\t");
            }
        }
    }

    protected void randomIntegerArray() {
        for (SignatureType methodSignature : getIntsSignatures()) {
            System.out.println("\n\twith signature: " + methodSignature.name());
            Arrays.stream(getRandomInts(methodSignature))
                    .forEach(r -> System.out.print(r + "\t"));
        }
    }

}
