package org.jcg.zheng.random;

import java.util.Random;

import org.jcg.zheng.RandomIntegerBase;
import org.jcg.zheng.SignatureType;

public class With_Random extends RandomIntegerBase {

    private Random random = new Random();

    @Override
    protected SignatureType[] getNextIntSignatures() {
        return new SignatureType[] { SignatureType.NONE, SignatureType.HAS_BOUNDARY };
    }

    @Override
    protected SignatureType[] getIntsSignatures() {
        return new SignatureType[] { SignatureType.NONE, SignatureType.HAS_BOUNDARY,
            SignatureType.HAS_BOUNDARY_AND_ORIGIN, SignatureType.HAS_SIZE };
    }

    @Override
    protected int getRandomInteger(SignatureType methodSignatureType) {
        int randomNum = -1;
        switch (methodSignatureType) {
        case NONE:
            randomNum = random.nextInt();
            break;
        case HAS_BOUNDARY:
            randomNum = random.nextInt(boundary);
            break;
        case HAS_BOUNDARY_AND_ORIGIN:
            break;
        case HAS_SIZE:
            break;
        default:
            break;
        }
        return randomNum;
    }

    @Override
    protected int[] getRandomInts(SignatureType methodSignatureType) {
        int[] randomNums = null;

        switch (methodSignatureType) {
        case NONE:
            randomNums = random.ints().limit(streamSize).toArray();
            break;
        case HAS_BOUNDARY:
            randomNums = random.ints(origin, boundary).limit(streamSize).toArray();
            break;
        case HAS_BOUNDARY_AND_ORIGIN:
            randomNums = random.ints(streamSize, origin, boundary).toArray();
            break;
        case HAS_SIZE:
            randomNums = random.ints(streamSize).toArray();
            break;
        default:
            break;
        }
        return randomNums;
    }

}