/*
 * Copyright 2012-2019 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.springframework.boot.docs.test.autoconfigure.restdocs.webclient;

import org.springframework.boot.test.autoconfigure.restdocs.RestDocsWebTestClientConfigurationCustomizer;
import org.springframework.boot.test.context.TestConfiguration;
import org.springframework.restdocs.webtestclient.WebTestClientRestDocumentationConfigurer;

public class AdvancedConfigurationExample {

	// tag::configuration[]
	@TestConfiguration
	public static class CustomizationConfiguration
			implements RestDocsWebTestClientConfigurationCustomizer {

		@Override
		public void customize(WebTestClientRestDocumentationConfigurer configurer) {
			configurer.snippets().withEncoding("UTF-8");
		}

	}
	// end::configuration[]

}
