package com.springcloud.hystrix;

import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.cloud.client.circuitbreaker.EnableCircuitBreaker;

/**
 * @author yatin-batra
 * Main implementation class which serves following purpose in a spring boot application: 
 * 		a. Configuration and bootstrapping.
 * 		b. Enables the cache-management ability in a spring framework.
 */
@SpringBootApplication		// This annotation boostraps and auto-configure the application.
@EnableCircuitBreaker		// This annotation enables the circuit breaker for the microservice.
public class Hystrixapplication {

	public static void main(String[] args) {
		SpringApplication.run(Hystrixapplication.class, args);
	}
}