package jcg.functionalinterface.example;

import java.util.Arrays;
import java.util.List;
import java.util.function.Predicate;

interface MyRectangle {
	int calculateVolumne(int length, int height, int width);
}

public class FunctionalInterface {

	static List<String> countries = Arrays.asList("America", "India", "Russia", "China", "Japan", "Indonesia");

	public static void main(String[] args) {

		// Example #1 - Implementing user-defined functional interface using lambda expression.
		MyRectangle rectangle = (int length, int height, int width) -> length * height * width;
		System.out.println(rectangle.calculateVolumne(5, 5, 5));

		// Example #2 - Runnable functional interface using anonymous class.
		Runnable runnableUsingAnonymousClass = new Runnable() {
			@Override
			public void run() {
				System.out.println("Hello World from Anonymous Class!");
			}
		};
		Thread myThread1 = new Thread(runnableUsingAnonymousClass);
		myThread1.start();

		// Example #3 - Runnable functional interface using lambda expression.
		Runnable runnableUsingLambda = () -> { 
			System.out.println("Hello World from Lambda Expression!"); 
		};
		Thread myThread2 = new Thread(runnableUsingLambda);
		myThread2.start();

		// Example #4 - Predicate functional interface.
		Predicate<String> predicate = (name) -> name.startsWith("I");
		for(String name : countries) {
			if(predicate.test(name))
				System.out.println(name);
		}
	}
}