package jcg.lambdaexpression;

@FunctionalInterface
interface Interface1 {
	public void greetings();
}

@FunctionalInterface
interface Interface2 {
	public void name(String name);
}

@FunctionalInterface
interface Interface3 {
	public void add(int a, int b);
}

@FunctionalInterface
interface Interface4 {
	public int multiple(int x);
}

public class Lambdaexpression {

	public static void main(String[] args) {

		// Lambda expression with no parameter.
		Interface1 interf1 = () -> {
			System.out.println("Hello World!");
		};
		interf1.greetings();

		// Lambda expression with single parameter.
		// Here java compiler can detect the parameter type based on the context (i.e. Type coherence).
		// Thus the lambda expression can be rewritten as :: Interface2 interf2 = (name) -> {	System.out.println("My name is= " + name);		};
		Interface2 interf2 = (String name) -> {
			System.out.println("My name is= " + name);
		};
		interf2.name("Java");

		// Lambda expression with multiple parameter.
		Interface3 interf3 = (int a, int b) -> {
			System.out.println("Total sum is= " + (a+b));
		};
		interf3.add(5, 5);

		// Lambda expression with return keyword.
		// Here as curly parentheses consists of a single statement, we can omit them and the return keyword.
		// Thus the lambda expression can be rewritten as :: Interface4 interf4 = (int x) -> x*x;
		Interface4 interf4 = (int x) -> {
			return x*x;
		};
		System.out.println("Total result is= " + interf4.multiple(10));
	}
}