package jcg.zheng.demo;

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertFalse;
import static org.junit.Assert.assertNotNull;
import static org.junit.Assert.assertTrue;
import static org.junit.Assert.fail;

import org.apache.commons.beanutils.BeanUtils;
import org.junit.Test;

import jcg.zheng.demo.data.Contact;
import jcg.zheng.demo.data.NoDefaultConstructorPOJO;
import jcg.zheng.demo.data.Person;

public class CloneBeanTest extends TestBase {

	@Test
	public void test_cloneBean() {
		try {
			Contact cloneMary = (Contact) BeanUtils.cloneBean(mary);

			assertEquals(mary.getFirstName(), cloneMary.getFirstName());
			assertEquals(mary.getLastName(), cloneMary.getLastName());
			assertNotNull(cloneMary.getCellPhone());
			assertEquals(mary.getCellPhone().getAreaCode(), cloneMary.getCellPhone().getAreaCode());
			assertEquals(mary.getCellPhone().getCountryCode(), cloneMary.getCellPhone().getCountryCode());
			assertEquals(mary.getCellPhone().getPhoneNum(), cloneMary.getCellPhone().getPhoneNum());
			assertNotNull(cloneMary.getHomePhone());
			assertEquals(mary.getHomePhone().getAreaCode(), cloneMary.getHomePhone().getAreaCode());
			assertEquals(mary.getHomePhone().getCountryCode(), cloneMary.getHomePhone().getCountryCode());
			assertEquals(mary.getHomePhone().getPhoneNum(), cloneMary.getHomePhone().getPhoneNum());

			assertNotNull(cloneMary.getTopics());
			assertEquals(mary.getTopics().size(), cloneMary.getTopics().size());
			assertTrue(cloneMary.getTopics().contains(TOPIC_1));
			assertTrue(cloneMary.getTopics().contains(TOPIC_2));
			assertTrue(cloneMary.getTopics().contains(TOPIC_3));

			assertNotNull(cloneMary.getAddtionalProperties());
			assertEquals(mary.getAddtionalProperties().size(), cloneMary.getAddtionalProperties().size());
			assertEquals(mary.getAddtionalProperties().get(KEY_1), cloneMary.getAddtionalProperties().get(KEY_1));
			assertEquals(mary.getAddtionalProperties().get(KEY_2), cloneMary.getAddtionalProperties().get(KEY_2));

		} catch (Exception e) {
			fail(SHOULD_NOT_REACH);
		}
	}

	@Test
	public void test_cloneBean_error_NoDefaultConstructorPOJO() {
		NoDefaultConstructorPOJO object = new NoDefaultConstructorPOJO("Test");
		try {
			BeanUtils.cloneBean(object);
		} catch (Exception e) {
			assertEquals(InstantiationException.class, e.getClass());
		}
	}

	@Test
	public void test_cloneBean_wont_clone_getter_not_follow_naming() {
		Person person = new Person();
		person.setSomeData(Boolean.TRUE);
		assertTrue(person.isSomeData());
		try {
			BeanUtils.copyProperties(person, mary);
			person.setSomeData(Boolean.TRUE);
			assertTrue(person.isSomeData());

			Person clonedPon = (Person) BeanUtils.cloneBean(person);
			assertFalse(clonedPon.isSomeData());
			
		} catch (Exception e) {
			fail(SHOULD_NOT_REACH);
		}
	}
}
