package jcg.zheng.demo;

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertNotNull;
import static org.junit.Assert.assertNull;
import static org.junit.Assert.assertTrue;
import static org.junit.Assert.fail;

import java.lang.reflect.InvocationTargetException;

import org.apache.commons.beanutils.BeanUtils;
import org.junit.Test;

import jcg.zheng.demo.data.NoDefaultConstructorPOJO;
import jcg.zheng.demo.data.Person;

public class CopyPropertiesTest extends TestBase {

	@Test
	public void test_copyProperties() {
		Person person = new Person();
		try {
			BeanUtils.copyProperties(person, mary);
			assertEquals(mary.getFirstName(), person.getFirstName());
			assertEquals(mary.getLastName(), person.getLastName());
			assertNotNull(person.getCellPhone());
			assertEquals(mary.getCellPhone().getAreaCode(), person.getCellPhone().getAreaCode());
			assertEquals(mary.getCellPhone().getCountryCode(), person.getCellPhone().getCountryCode());
			assertEquals(mary.getCellPhone().getPhoneNum(), person.getCellPhone().getPhoneNum());
			assertNotNull(person.getHomePhone());
			assertEquals(mary.getHomePhone().getAreaCode(), person.getHomePhone().getAreaCode());
			assertEquals(mary.getHomePhone().getCountryCode(), person.getHomePhone().getCountryCode());
			assertEquals(mary.getHomePhone().getPhoneNum(), person.getHomePhone().getPhoneNum());

			assertNotNull(person.getTopics());
			assertEquals(mary.getTopics().size(), person.getTopics().size());
			assertTrue(person.getTopics().contains(TOPIC_1));
			assertTrue(person.getTopics().contains(TOPIC_2));
			assertTrue(person.getTopics().contains(TOPIC_3));

			assertNotNull(person.getAddtionalProperties());
			assertEquals(mary.getAddtionalProperties().size(), person.getAddtionalProperties().size());
			assertEquals(mary.getAddtionalProperties().get(KEY_1), person.getAddtionalProperties().get(KEY_1));
			assertEquals(mary.getAddtionalProperties().get(KEY_2), person.getAddtionalProperties().get(KEY_2));

			assertNull(person.getSomeData());

		} catch (IllegalAccessException | InvocationTargetException e) {
			fail(SHOULD_NOT_REACH);
		}
	}

	@Test
	public void test_copyProperties_NoDefaultConstructorPOJO() {
		NoDefaultConstructorPOJO pojo = new NoDefaultConstructorPOJO("Test");
		try {
			BeanUtils.copyProperties(pojo, mary);
			assertEquals("Test", pojo.getName());
		} catch (IllegalAccessException | InvocationTargetException e) {
			fail(SHOULD_NOT_REACH);
		}
	}

}
