package jcg.zheng.demo;

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.fail;

import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.beanutils.PropertyUtils;
import org.junit.Test;

import jcg.zheng.demo.data.NoDefaultConstructorPOJO;

public class IndexedPropertyTest extends TestBase {

	@Test
	public void getIndexedProperty() {
		try {
			String topic = BeanUtils.getIndexedProperty(mary, "topics[0]");
			assertEquals(TOPIC_1, topic);

			topic = BeanUtils.getIndexedProperty(mary, "topics[2]");
			assertEquals(TOPIC_3, topic);

		} catch (Exception e) {
			fail(SHOULD_NOT_REACH);
		}
	}

	@Test
	public void getIndexedProperty_error() {
		try {
			BeanUtils.getIndexedProperty(mary, "topics[3]");
		} catch (Exception e) {
			assertEquals(ArrayIndexOutOfBoundsException.class, e.getClass());
		}
	}

	@Test
	public void getIndexedProperty_index() {
		try {
			String topic = BeanUtils.getIndexedProperty(mary, "topics", 1);
			assertEquals(TOPIC_2, topic);

		} catch (Exception e) {
			fail(SHOULD_NOT_REACH);
		}
	}

	@Test
	public void getIndexedProperty_index_error() {
		try {
			BeanUtils.getIndexedProperty(mary, "topics", 3);
		} catch (Exception e) {
			assertEquals(ArrayIndexOutOfBoundsException.class, e.getClass());
		}
	}

	@Test
	public void getProperty() {
		try {
			String value = BeanUtils.getProperty(mary, "topics[1]");
			assertEquals("BeanUtils", value);
		} catch (Exception e) {
			fail(SHOULD_NOT_REACH);
		}
	}

	@Test
	public void getter() {
		try {
			assertEquals(3, mary.getTopics().size());
		} catch (Exception e) {
			fail(SHOULD_NOT_REACH);
		}
	}

	@Test
	public void setIndexedProperty() {
		try {
			PropertyUtils.setIndexedProperty(mary, "topics[1]", "Java 8");
			assertEquals("Java 8", mary.getTopics().get(1));
		} catch (Exception e) {
			fail(SHOULD_NOT_REACH);
		}
	}

	@Test
	public void setIndexedProperty_index() {
		try {
			PropertyUtils.setIndexedProperty(mary, "topics", 1, "Java 8");
			assertEquals("Java 8", mary.getTopics().get(1));
		} catch (Exception e) {
			fail(SHOULD_NOT_REACH);
		}
	}
	
	@Test
	public void setProperty() {
		try {
			BeanUtils.setProperty(mary, "topics[1]", "Java 12");
			assertEquals("Java 12", mary.getTopics().get(1));
		} catch (Exception e) {
			fail(SHOULD_NOT_REACH);
		}
	}

	@Test
	public void setProperty_NoDefaultConstructorPOJO() {
		NoDefaultConstructorPOJO object = new NoDefaultConstructorPOJO("Test");
		try {
			BeanUtils.setProperty(object, "name", "Java");
			assertEquals("Java", object.getName());
		} catch (Exception e) {
			fail(SHOULD_NOT_REACH);
		}
	}
}
