package jcg.zheng.demo;

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertNull;
import static org.junit.Assert.fail;

import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.beanutils.PropertyUtils;
import org.junit.Test;

public class MappedPropertyTest extends TestBase {

	@Test
	public void getMappedProperty() {
		try {

			String colorValue = BeanUtils.getMappedProperty(mary, "addtionalProperties(Color)");
			assertEquals(VALUE_1, colorValue);

		} catch (Exception e) {
			fail(SHOULD_NOT_REACH);
		}
	}

	@Test
	public void getMappedProperty_error_notexist_property() {
		try {
			BeanUtils.getMappedProperty(mary, "NA");
		} catch (Exception e) {
			assertEquals(IllegalArgumentException.class, e.getClass());
		}
	}

	@Test
	public void getMappedProperty_key() {
		try {
			String keyValue = BeanUtils.getMappedProperty(mary, "addtionalProperties", KEY_1);
			assertEquals(VALUE_1, keyValue);

			keyValue = BeanUtils.getMappedProperty(mary, "addtionalProperties", KEY_2);
			assertEquals(VALUE_2, keyValue);

		} catch (Exception e) {
			fail(SHOULD_NOT_REACH);
		}
	}

	@Test
	public void getMappedProperty_return_null_for_not_exist_key() {
		try {
			String naValue = BeanUtils.getMappedProperty(mary, "addtionalProperties", "NA");
			assertNull(naValue);
		} catch (Exception e) {
			fail(SHOULD_NOT_REACH);
		}
	}

	@Test
	public void getProperty() {
		try {
			String value = BeanUtils.getProperty(mary, "addtionalProperties(Color)");

			assertEquals("Purple", value);
		} catch (Exception e) {
			fail(SHOULD_NOT_REACH);
		}
	}

	@Test
	public void getter() {
		try {
			assertEquals(2, mary.getAddtionalProperties().size());
		} catch (Exception e) {
			fail(SHOULD_NOT_REACH);
		}
	}


	@Test
	public void setMappedProperty() {
		try {
			PropertyUtils.setMappedProperty(mary, "addtionalProperties(Color)", "Blue");
			assertEquals("Blue", mary.getAddtionalProperties().get(KEY_1));
		} catch (Exception e) {
			fail(SHOULD_NOT_REACH);
		}
	}
	
	@Test
	public void setMappedProperty_key() {
		try {
			PropertyUtils.setMappedProperty(mary, "addtionalProperties", KEY_1, "Blue");
			assertEquals("Blue", mary.getAddtionalProperties().get(KEY_1));
		} catch (Exception e) {
			fail(SHOULD_NOT_REACH);
		}
	}
	
	@Test
	public void setProperty() {
		try {
			BeanUtils.setProperty(mary, "addtionalProperties(Color)", "Green");

			assertEquals("Green", mary.getAddtionalProperties().get(KEY_1));
		} catch (Exception e) {
			fail(SHOULD_NOT_REACH);
		}
	}
}
