package jcg.zheng.demo;

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.fail;

import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.beanutils.PropertyUtils;
import org.junit.Test;

public class NestedPropertyTest extends TestBase {


	@Test
	public void getNestedProperty() {
		try {
			String areaCode = BeanUtils.getNestedProperty(mary, "cellPhone.areaCode");

			assertEquals("314", areaCode);
		} catch (Exception e) {
			fail(SHOULD_NOT_REACH);
		}
	}

	@Test
	public void getProperty() {
		try {
			String areaCode = BeanUtils.getProperty(mary, "cellPhone.areaCode");
			assertEquals("314", areaCode);
		} catch (Exception e) {
			fail(SHOULD_NOT_REACH);
		}
	}

	@Test
	public void getter() {
		try {
			assertEquals("314", mary.getCellPhone().getAreaCode());
		} catch (Exception e) {
			fail(SHOULD_NOT_REACH);
		}
	}

	@Test
	public void setNestedProperty() {
		try {
			PropertyUtils.setNestedProperty(mary, "cellPhone.areaCode", "404");

			assertEquals("404", mary.getCellPhone().getAreaCode());
		} catch (Exception e) {
			fail(SHOULD_NOT_REACH);
		}
	}
	
	@Test
	public void setProperty() {
		try {
			BeanUtils.setProperty(mary, "cellPhone.areaCode", "636");
			assertEquals("636", mary.getCellPhone().getAreaCode());
		} catch (Exception e) {
			fail(SHOULD_NOT_REACH);
		}
	}
}
