package jcg.zheng.demo;

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.fail;

import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.beanutils.PropertyUtils;
import org.junit.Test;

public class SimplePropertyTest extends TestBase {

	@Test
	public void getProperty_for_definedProperty() {
		try {
			String fname = BeanUtils.getProperty(mary, "firstName");
			assertEquals("Mary", fname);
		} catch (Exception e) {
			fail(SHOULD_NOT_REACH);
		}
	}

	@Test
	public void getSimpleProperty_retrun_value_for_definedProperty() {
		try {
			String firstName = BeanUtils.getSimpleProperty(mary, "firstName");
			assertEquals("Mary", firstName);
		} catch (Exception e) {
			fail(SHOULD_NOT_REACH);
		}
	}

	@Test
	public void getter_return_value_for_definedProperty() {
		try {
			assertEquals("Mary", mary.getFirstName());
		} catch (Exception e) {
			fail(SHOULD_NOT_REACH);
		}
	}
	
	@Test
	public void setProperty_for_definedProperty() {
		try {
			BeanUtils.setProperty(mary, "firstName", "UpdateMary");
			assertEquals("UpdateMary", mary.getFirstName());
		} catch (Exception e) {
			fail(SHOULD_NOT_REACH);
		}
	}

	@Test
	public void setProperty_for_not_definedProperty() {
		try {
			BeanUtils.setProperty(mary, "noGetter", Integer.valueOf(1));
		} catch (Exception e) {
			fail(SHOULD_NOT_REACH);
		}
	}

	@Test
	public void setSimpleProperty_for_definedProperty() {
		try {
			PropertyUtils.setSimpleProperty(mary, "firstName", "UpdateMary");
			assertEquals("UpdateMary", mary.getFirstName());
		} catch (Exception e) {
			fail(SHOULD_NOT_REACH);
		}
	}

	@Test
	public void setSimpleProperty_for_NamingNotMatchProperty() {		
		try {
			PropertyUtils.setSimpleProperty(mary, "someData", true);
		} catch (Exception e) {
			assertEquals(NoSuchMethodException.class, e.getClass());
		}		
	}

	@Test
	public void setSimpleProperty_for_not_definedProperty() {
		try {
			PropertyUtils.setSimpleProperty(mary, "isSomeData", Integer.valueOf(1));
		} catch (Exception e) {
			assertEquals(NoSuchMethodException.class, e.getClass());
		}
	}
}
