package jcg.zheng.demo;

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.fail;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;

import org.apache.commons.beanutils.BeanUtils;
import org.junit.Before;
import org.junit.Test;

import jcg.zheng.demo.data.Contact;
import jcg.zheng.demo.data.Phone;

public class TestBase {

	protected static final String KEY_1 = "Color";
	protected static final String KEY_2 = "Food";
	protected static final String SHOULD_NOT_REACH = "should not reach here!";
	protected static final String TOPIC_1 = "Interface design";
	protected static final String TOPIC_2 = "BeanUtils";
	protected static final String TOPIC_3 = "Functional Interface";
	protected static final String VALUE_1 = "Purple";
	protected static final String VALUE_2 = "Rice";

	protected Contact mary;

	public TestBase() {
		super();
	}

	protected Contact buildContact(String firstName, String lastName) {
		Contact contact = new Contact();
		contact.setFirstName(firstName);
		contact.setLastName(lastName);

		contact.setTopics(Arrays.asList(TOPIC_1, TOPIC_2, TOPIC_3));
		HashMap<String, String> addtionalProperties = new HashMap<>();
		addtionalProperties.put(KEY_1, VALUE_1);
		addtionalProperties.put(KEY_2, VALUE_2);
		contact.setAddtionalProperties(addtionalProperties);
		contact.setCellPhone(buildPhone("8197000"));
		contact.setHomePhone(buildPhone("5272943"));

		return contact;
	}

	protected Phone buildPhone(String phoneNum) {
		Phone cellPhone = new Phone();
		cellPhone.setCountryCode("01");
		cellPhone.setAreaCode("314");
		cellPhone.setPhoneNum(phoneNum);

		return cellPhone;
	}

	@Before
	public void setup() {
		mary = buildContact("Mary", "Zheng");
	}
	
	@Test
	public void test_describe() {
		try {
			Map<String, String> maryContactMeta = BeanUtils.describe(mary);
			assertEquals("Mary", maryContactMeta.get("firstName"));
			assertEquals("Zheng", maryContactMeta.get("lastName"));
			assertEquals("{Color=Purple, Food=Rice}", maryContactMeta.get("addtionalProperties"));			 
		} catch (Exception e) {
			fail(SHOULD_NOT_REACH);
		}  
	}

}