package com.javacodegeeks.examples.list;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;

public class ArrayListDemo {
	public static void main(String[] args) {

		construstorDemo();

		containsMethodDemo();

		iteratingListDemo();

		getElementByIndex();

		indexOfDemo();

		addMethodDemo();

		clearMethodDemo();

		containsMethodDemo();

		removeMethodDemo();

		setMethodDemo();

		sublistDemo();
	}

	private static void sublistDemo() {
		List<String> integerListWithOtherCollection = new ArrayList<String>(
				Arrays.asList("Jack", "is", "a", "good", "kid", "but", "he", "is", "very", "noughty"));
		System.out.println(integerListWithOtherCollection.subList(0, 5));

	}

	private static void setMethodDemo() {
		List<Integer> integerList = new ArrayList<Integer>(Arrays.asList(1, 2, 3));
		System.out.println("Initial List" + integerList);
		integerList.set(2, 5);
		System.out.println("List after replacing 2nd index value to 5" + integerList);

	}

	private static void removeMethodDemo() {
		List<String> integerListWithOtherCollection = new ArrayList<String>(
				Arrays.asList("Jack", "is", "a", "good", "kid", "but", "he", "is", "very", "noughty"));
		System.out.println(integerListWithOtherCollection);
		integerListWithOtherCollection.remove(2);
		System.out.println(integerListWithOtherCollection);
		integerListWithOtherCollection.remove("but");
		System.out.println(integerListWithOtherCollection);
		integerListWithOtherCollection.removeAll(Arrays.asList("very"));
		System.out.println(integerListWithOtherCollection);
		integerListWithOtherCollection.removeIf(x -> x.contains("good"));
		System.out.println(integerListWithOtherCollection);

	}

	private static void clearMethodDemo() {
		List<Integer> integerListWithOtherCollection = new ArrayList<Integer>(Arrays.asList(1, 2, 3));
		System.out.println(integerListWithOtherCollection);
		integerListWithOtherCollection.clear();
		System.out.println(integerListWithOtherCollection);
	}

	private static void addMethodDemo() {
		List<Integer> integerList = new ArrayList<Integer>();
		List<Integer> integerListWithOtherCollection = new ArrayList<Integer>(Arrays.asList(1, 2, 3));
		// Adding element at the end of the list
		integerList.add(1);

		System.out.println(integerList);
		// Adding collection of elements at the end of the list
		integerList.addAll(integerListWithOtherCollection);
		System.out.println(integerList);
		// Adding element on perticular index of the list
		integerList.add(3, 100);
		System.out.println(integerList);
		// Adding collection of elements on perticular index of the list
		integerList.addAll(0, integerListWithOtherCollection);
		System.out.println(integerList);

	}

	private static void indexOfDemo() {
		List<Integer> integerListWithOtherCollection = new ArrayList<Integer>(Arrays.asList(1, 2, 3));
		System.out.println("Index of 3 is: " + integerListWithOtherCollection.indexOf(3));
		System.out.println("Index of 4 is: " + integerListWithOtherCollection.indexOf(4));

	}

	private static void getElementByIndex() {

		List<Integer> integerListWithOtherCollection = new ArrayList<Integer>(Arrays.asList(1, 2, 3));
		// Getting Element By index
		System.out.println("Element at index 1 is: " + integerListWithOtherCollection.get(1));
		System.out.println("Element at index 2 is: " + integerListWithOtherCollection.get(2));

	}

	private static void iteratingListDemo() {
		List<Integer> integerListWithOtherCollection = new ArrayList<Integer>(Arrays.asList(1, 2, 3));
		// Iterate using iterator
		Iterator<Integer> integerListWithOtherCollectionItr = integerListWithOtherCollection.iterator();
		System.out.println("Using Iterator");
		while (integerListWithOtherCollectionItr.hasNext())
			System.out.println(integerListWithOtherCollectionItr.next());

		System.out.println("using forEach()");

		// Iterate using forEach()
		integerListWithOtherCollection.forEach(System.out::println);

	}

	private static void containsMethodDemo() {
		List<Integer> integerListWithOtherCollection = new ArrayList<Integer>(Arrays.asList(1, 2, 3));
		System.out.println(integerListWithOtherCollection.contains(3));
		System.out.println(integerListWithOtherCollection.contains(7));

	}

	private static void construstorDemo() {
		// ArrayList with default constructor
		List<Integer> integerList = new ArrayList<Integer>();
		// ArrayList with default capicity
		List<Integer> integerListWithInnitialCapacity = new ArrayList<Integer>(10);
		// ArrayList with other collection class
		List<Integer> integerListWithOtherCollection = new ArrayList<Integer>(Arrays.asList(1, 2, 3));

	}

}
