package com.javacodegeeks.examples.list;

import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedList;

public class LinkedListDemo {
	public static void main(String[] args) {
		construstorDemo();

		addMethodDemo();

		clearMethodDemo();

		containsMethodDemo();

		iteratingLinkedList();

		getElementByIndex();
		indexOfDemo();

		removeMethodDemo();

		setMethodDemo();

	}

	private static void setMethodDemo() {
		LinkedList<String> linkedList = new LinkedList<String>(Arrays.asList("Alex", "John", "Martin"));
		System.out.println("Innitial Linked list: " + linkedList);
		System.out.println("Updating John(at index 1) to Elizabeth");
		linkedList.set(1, "Elizabeth");
		System.out.println("Updated Linked list: " + linkedList);
		
	}

	private static void removeMethodDemo() {
		LinkedList<String> linkedList =
			    new LinkedList<String>(Arrays.asList("Alex", "John", "Martin", "Google", "Andrews", "Elizabeth", "Andrews"));
			System.out.println("Innitial Linked list: " + linkedList);
			 
			System.out.println("removing the head (first element) of list.");
			linkedList.remove();
			System.out.println("Updated Linked list: " + linkedList);
			 
			System.out.println("removing the element at index 1 in this list.");
			linkedList.remove(1);
			System.out.println("Updated Linked list: " + linkedList);
			 
			System.out.println("removing the first occurrence of the specified element(Elizabeth) from this list, if it is present.");
			linkedList.remove("Elizabeth");
			System.out.println("Updated Linked list: " + linkedList);
			 
			System.out.println("removing the first element from this list.");
			linkedList.removeFirst();
			System.out.println("Updated Linked list: " + linkedList);
			 
			System.out.println("removing the last element from this list.");
			linkedList.removeLast();
			System.out.println("Updated Linked list: " + linkedList);
			 
			System.out.println(
			    "removing the first occurrence of the specified element(Google) in this list (when traversing the list from head to tail).");
			linkedList.removeFirstOccurrence("Google");
			System.out.println("Updated Linked list: " + linkedList);
			 
			System.out.println(
			    "removing the last occurrence of the specified element(Andrews) in this list (when traversing the list from head to tail).");
			linkedList.removeLastOccurrence("Andrews");
			System.out.println("Updated Linked list: " + linkedList);
		
	}

	private static void indexOfDemo() {
		LinkedList<String> linkedList = new LinkedList<String>(Arrays.asList("Andrews", "Elizabeth", "Andrews"));
	    System.out.println("First Index of Andrews is: " + linkedList.indexOf("Andrews"));
	    System.out.println("Last Index of Andrews is: " + linkedList.lastIndexOf("Andrews"));
	    System.out.println("First Index of Bob is: " + linkedList.lastIndexOf("Bob"));
		
	}

	private static void getElementByIndex() {

		LinkedList<String> linkedList = new LinkedList<String>();
		linkedList.addAll(Arrays.asList("Andrews", "Elizabeth", "Bob"));

		// First Element using element() method
		System.out.println("First Element using element() method: " + linkedList.element());

		// First Element using getFirst() method
		System.out.println("First Element using getFirst() method: " + linkedList.getFirst());

		// First Element using peek() method
		System.out.println("First Element using peek() method: " + linkedList.peek());

		// First Element using peekFirst() method
		System.out.println("First Element using peekFirst() method: " + linkedList.peekFirst());

		// Last Element using getLast() method
		System.out.println("Last Element using getLast() method: " + linkedList.getLast());

		// Last Element using peekLast() method
		System.out.println("Last Element using peekLast() method: " + linkedList.peekLast());

		// 1st index Element using get() method
		System.out.println("1st index Element using get() method: " + linkedList.get(1));

	}

	private static void iteratingLinkedList() {
		LinkedList<String> linkedList = new LinkedList<String>();
		linkedList.addAll(Arrays.asList("Andrews", "Elizabeth", "Bob"));

		System.out.println("Using default Iterator");
		Iterator<String> linkedListIterator = linkedList.iterator();
		while (linkedListIterator.hasNext())
			System.out.println(linkedListIterator.next());

		System.out.println("Using default ListIterator");
		Iterator<String> listIterator = linkedList.listIterator();
		while (listIterator.hasNext())
			System.out.println(listIterator.next());

		System.out.println("Using default ListIterator from specified index");
		Iterator<String> listIteratorFrom1stIndex = linkedList.listIterator(1);
		while (listIteratorFrom1stIndex.hasNext())
			System.out.println(listIteratorFrom1stIndex.next());

		System.out.println("Using default DecendingIterator");
		Iterator<String> decendingListIterator = linkedList.descendingIterator();
		while (decendingListIterator.hasNext())
			System.out.println(decendingListIterator.next());

		System.out.println("Using for each loop");
		linkedList.forEach(System.out::println);

	}

	private static void containsMethodDemo() {

// Creating linkedList with collection
		LinkedList<String> linkedList = new LinkedList<String>(Arrays.asList("Jack", "John"));
		System.out.println("initial linkedList: " + linkedList);
// checking Jack is there in LinkedList
		System.out.println("Is Jack there in List ? " + linkedList.contains("Jack"));
// checking Hill is there in LinkedList
		System.out.println("Is Hill there in List ? " + linkedList.contains("Hill"));
	}

	private static void clearMethodDemo() {
		// Creating linkedList with collection
		LinkedList<String> linkedList = new LinkedList<String>(Arrays.asList("Jack", "John"));
		System.out.println(linkedList);
		// Clearing LinkedList
		linkedList.clear();
		System.out.println(linkedList);

	}

	private static void addMethodDemo() {
		// Creating empty LinkedList
		LinkedList<String> linkedList = new LinkedList<String>();
		System.out.println(linkedList);
		// adding an element at end of LinkedList using add()
		linkedList.add("Jack");
		linkedList.add("John");
		System.out.println(linkedList);
		// adding an element at 0th index LinkedList
		linkedList.add(0, "Hill");
		System.out.println(linkedList);
		// adding an collection at end of LinkedList
		linkedList.addAll(Arrays.asList("Andrews", "Elizabeth"));
		System.out.println(linkedList);
		// adding an collection at 1st index of LinkedList
		linkedList.addAll(1, Arrays.asList("Cedric", "Aaron"));
		System.out.println(linkedList);
		// adding an element at start of LinkedList
		linkedList.addFirst("Roger");
		System.out.println(linkedList);
		// adding an element at end of LinkedList
		linkedList.addLast("Jeanette");
		System.out.println(linkedList);

	}

	private static void construstorDemo() {
		// ArrayList with default constructor
		LinkedList<String> linkedList = new LinkedList<String>();
		// ArrayList with other collection class
		LinkedList<String> linkedListFromCollection = new LinkedList<String>(Arrays.asList("Jack", "John"));

	}

}
