package com.javacodegeeks.examples;

import static org.junit.Assert.assertTrue;

import org.junit.Test;

public class DecimalNumberRounderTest {

	@Test
	public void roundNumbersTest() {
		assertTrue(DecimalNumberRounder.roundNumbers(123.4567, 3) == 123.457);
		assertTrue(DecimalNumberRounder.roundNumbers(123.4564, 3) == 123.456);
		assertTrue(DecimalNumberRounder.roundNumbers(123.4567, 2) == 123.46);
	}

	@Test
	public void roundUsingBigDecimalTest() {
		assertTrue(DecimalNumberRounder.roundUsingBigDecimal(123.4567, 3) == 123.457);
		assertTrue(DecimalNumberRounder.roundUsingBigDecimal(123.4564, 3) == 123.456);
		assertTrue(DecimalNumberRounder.roundUsingBigDecimal(123.4567, 2) == 123.46);
	}

	@Test
	public void roundUsingStringFormatorTest() {
		assertTrue(DecimalNumberRounder.roundUsingStringFormator(123.4567, 3) == 123.457);
		assertTrue(DecimalNumberRounder.roundUsingStringFormator(123.4564, 3) == 123.456);
		assertTrue(DecimalNumberRounder.roundUsingStringFormator(123.4567, 2) == 123.46);
	}

	@Test
	public void roundUsingDecimal4JTest() {
		assertTrue(DecimalNumberRounder.roundUsingDecimal4J(123.4567, 3) == 123.457);
		assertTrue(DecimalNumberRounder.roundUsingDecimal4J(123.4564, 3) == 123.456);
		assertTrue(DecimalNumberRounder.roundUsingDecimal4J(123.4567, 2) == 123.46);
	}

	@Test
	public void roundUsingApacheCommonsMath3Test() {
		assertTrue(DecimalNumberRounder.roundUsingApacheCommonsMath3(123.4567, 3) == 123.457);
		assertTrue(DecimalNumberRounder.roundUsingApacheCommonsMath3(123.4564, 3) == 123.456);
		assertTrue(DecimalNumberRounder.roundUsingApacheCommonsMath3(123.4567, 2) == 123.46);
	}
}