package jcg.zheng.demo;

import static org.junit.Assert.assertEquals;

import java.text.NumberFormat;
import java.util.Locale;

import org.junit.Test;

public class NumberFormatTest {

	private NumberFormat usNumFormat = NumberFormat.getInstance(new Locale("en", "US"));;

	@Test
	public void formatDecimal() {	 
		usNumFormat.setMaximumFractionDigits(4);
		usNumFormat.setMinimumFractionDigits(2);
	 
		assertEquals("123.4568",  usNumFormat.format(123.45678));
	}

	@Test
	public void formatInteger() {
		assertEquals("100", usNumFormat.format(100l));
	}

	@Test
	public void formatPercentage() {
		NumberFormat nf = NumberFormat.getPercentInstance();
	 
		assertEquals("25%", nf.format(0.25));
	}

}
