package jcg.zheng.demo;

import java.util.MissingFormatArgumentException;

import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TestRule;
import org.junit.rules.TestWatcher;
import org.junit.runner.Description;

public class PrintfFormatBaseTest {
	
	@Rule
	public TestRule echoMethodName = new TestWatcher() {
		protected void starting(Description desc) {
			System.out.println("\nTestMethodName:" + desc.getMethodName());
		}
	};
 
	protected static final String BOOLEAN_B = "%%b - format boolean value: %b, %%B - Boolean value: %B";
	protected static final String CHAR_C = "%%c - format char with lower-case value: %c, %%C - with upper-case value: %C.";
	protected static final String DECIMAL_F = "%%f - doubleValue is: %f. floatValue is: %f";
	protected static final String DECIMAL_FLAGS_WIDTH_PRECISION = "%%-+,10.2f - Format a negative number by left-justified, separating with comma, with a sign, 10 width, and 2 precision: %-+,10.2f";
	protected static final String DECIMAL_PADDING_BLANK = "%% 10.3f - Format a decimal with padding empty space: % 10.3f";
	protected static final String DECIMAL_PADDING_ZERO = "%%010.3f - Format a decimal with padding zero: %010.3f";

	protected static final String EXPONENTIAL_E = "%%e - exponential number. Value is: %e.";

	protected static final String HASHCODE_H = "The string object's hashcode: %h, the interger's hashcode: %h";
	protected static final String INTEGER_D_BASE10 = "%%d - byteValue is: %d, shortValue is: %d, intValue is: %d, longValue is: %d.";

	protected static final String INTEGER_O_BASE8 = "%%o - Octal format. byteValue is: %o, shortValue is: %o, intValue is: %o, longValue is: %o.";
	protected static final String INTEGER_X_BASE16 = "%%x - Base 16. byteValue is: %x, shortValue is: %x, intValue is: %x, longValue is: %x.";
	protected static final String NEW_LINE = "%n";

	protected byte byteValue = 12;
	protected double doubleValue = 10.123;
	protected float floatValue = 123.45f;
	protected int intValue = 123;
	protected long longValue = 1234567;
	protected short shortValue = 121;

	@Test
	public void explicit_indexing_test() {
		System.out.printf("explicit two arguments: %1$s, %2$s", "Hello", "World!");		 
	}

	@Test
	public void explicit_indexing_test_differentOrder() {
		System.out.printf("explicit two arguments: %2$s, %1$s", "Hao!", "Ni");	 
	}

	@Test(expected = MissingFormatArgumentException.class)
	public void ordinary_indexing_test_exception() {
		System.out.printf("throw MissingFormatArgumentException: %s, %s", "test");	 
	}

	@Test
	public void relative_indexing_test() {
		System.out.printf("relative arguments - %1$s, %<s, %<s, %2$s, and %<s", "Zheng", "Mary");	 
	}
	
}