package jcg.zheng.demo;

import org.junit.Test;

public class Printf_NumberTest extends PrintfFormatBaseTest {


	@Test
	public void d_for_integer_base10() {
		System.out.printf(INTEGER_D_BASE10, byteValue, shortValue, intValue, longValue);
	}

	@Test
	public void e_for_exponential_number() {
		System.out.printf(EXPONENTIAL_E, floatValue);
	}

	@Test
	public void f_for_decimal() {
		System.out.printf(DECIMAL_F, doubleValue, floatValue);
	}

	@Test
	public void o_for_integer_base8() {
		System.out.printf(INTEGER_O_BASE8, byteValue, shortValue, intValue, longValue);
	}

	@Test
	public void padding_space() {
		// % 10.3f - Format a decimal with padding empty space: 125.100
		System.out.printf(DECIMAL_PADDING_BLANK, 125.1f);
	}

	@Test
	public void padding_zero() {
		// %010.3f - Format a decimal with padding zero: 000125.100
		System.out.printf(DECIMAL_PADDING_ZERO, 125.1f);
	}

	@Test
	public void with_all_formatting_flags_width_precision() {
		// %-+,10.2f - Format a negative number by left-justified, separating with comma,
		// with a sign, 10 width, and 2 precision: -12,345.12
		System.out.printf(DECIMAL_FLAGS_WIDTH_PRECISION, -12345.1234f);
	}

	@Test
	public void x_for_integer_base16() {
		System.out.printf(INTEGER_X_BASE16, byteValue, shortValue, intValue, longValue);
	}

}
