package jcg.zheng.demo;

import java.io.UnsupportedEncodingException;

import org.junit.Test;

public class Printf_StringTest extends PrintfFormatBaseTest {

	private boolean isFalse = false;
	private Boolean isTrue = Boolean.TRUE;

	@Test
	public void b_for_boolean() throws UnsupportedEncodingException {
		System.out.printf(BOOLEAN_B, isFalse, isTrue);
	}
	
	@Test
	public void b_for_String_always_True() throws UnsupportedEncodingException {
		System.out.printf(BOOLEAN_B, "test", 1);
	}

	@Test
	public void c_for_character() {
		System.out.printf(CHAR_C, 'm', 'm');
	}

	@Test
	public void h_for_hashcode() {
		String s = "Hello World";
		Integer number = Integer.valueOf(100);
		System.out.printf(HASHCODE_H, s, number);

	}

	@Test
	public void n_for_newline() {
		System.out.printf("Hello World%n2nd line");
	}

	@Test
	public void s_for_string() {
		String stringVal = "Hi, Mary!";
		System.out.printf("Left-justified is: %-20s\n", stringVal);
		System.out.printf("Uppercase, Right-justified is: %20S\n", stringVal);
	}

	@Test
	public void s_for_string_width_too_small() {
		String stringVal = "Hi, Mary!";
		System.out.printf("width is smaller: %2S", stringVal);
	}

}
