package jcg.zheng.demo;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;

public class InputStreamReaderApp {
	public static void main(String[] argu) {
		InputStreamReaderApp iApp = new InputStreamReaderApp();		
		System.out.println("Enter anything from the keyboard (q- quit):");		 
		iApp.read_in_write_out_and_log_error();
		
	}

	public String read_in_write_out_and_log_error() {
		String ret = null;
		try (BufferedReader br = new BufferedReader(new InputStreamReader(System.in))) {
			String strCurrentLine = null;

			while ((strCurrentLine = br.readLine()) != null) {
				System.out.println(strCurrentLine);
				if ("q".equalsIgnoreCase(strCurrentLine)) {
					System.out.println("Bye!");
					ret = "Bye";
					System.exit(0);
				} else {
					System.out.println("Value from System.in:" + strCurrentLine);
					try {
						ret = String.format("%4d", Integer.parseInt(strCurrentLine));
					} catch (NumberFormatException e) {
						ret = "Error";
						System.err.println("Caught NumberFormatException " + e.getMessage());
					}
				}
			}

		} catch (IOException e) {
			System.err.println("Caught Exception " + e.getMessage());
			ret = "Error";
		}
		return ret;
	}
}
