package jcg.zheng.demo;

import java.util.Scanner;

public class ScannerApp {

	public static void main(String[] argu) {
		ScannerApp sapp = new ScannerApp();
		System.out.println("Enter anything from the keyboard:");
		sapp.scan_in_write_out_and_log_error();
	}

	public String scan_in_write_out_and_log_error() {
		String ret = null;

		try (Scanner sc = new Scanner(System.in)) {
			while (sc.hasNextLine()) {
				String valueEntered = sc.nextLine();
				ret = valueEntered;
				System.out.println("Value from System.in:" + ret);
				if ("q".equalsIgnoreCase(valueEntered)) {
					System.out.println("Bye!");
					System.exit(0);
				}

				try {
					Integer.parseInt(valueEntered);
				} catch (NumberFormatException e) {
					System.err.println("Caught NumberFormatException " + e.getMessage());

				}
			}
		}
		return ret;
	}
}
