package jcg.zheng.demo;

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertNotNull;

import java.io.FileNotFoundException;

import org.junit.Test;

public class ScannerAppTest {

	ScannerApp scannerApp = new ScannerApp();

	@Test
	public void test_bytearray_as_in() {
		InputStreamHelper.setIn_from_ByteArrayInputStream("hello");
		String demo = scannerApp.scan_in_write_out_and_log_error();
		assertEquals("hello", demo);
	}


	@Test
	public void test_file_as_in_out() {
		try {
			PrintStreamHelper.setOut_from_OutStream("data/error_file.log");
			InputStreamHelper.setIn_from_FileInputStream("data/scan_in_file.txt");
			String entered = scannerApp.scan_in_write_out_and_log_error();
			assertNotNull(entered);

		} catch (FileNotFoundException e) {
			e.printStackTrace();
		}
	}

	@Test
	public void test_file_as_in_out_error() {
		try {
			InputStreamHelper.setIn_from_FileInputStream("data/scan_in_file.txt");
			PrintStreamHelper.setError_from_File("data/error_file.log");
			PrintStreamHelper.setOut_from_File("data/out_file.txt");

			String demo = scannerApp.scan_in_write_out_and_log_error();
			assertEquals("qest", demo);

		} catch (FileNotFoundException e) {
			e.printStackTrace();
		}

	}

	@Test
	public void test_url_as_in() {
		try {
			InputStreamHelper.setIn_from_URL("https://gmail.com");
			String lastStr = scannerApp.scan_in_write_out_and_log_error();
			assertNotNull(lastStr);
		} catch (Exception e) {
			e.printStackTrace();
		}
	}
}
