package com.javacodegeeks.examples.hashmap;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class HashMapDemo1 {
    public static void main(String[] args) {

        //computeMethodDemo();
        //containsMethodDemo();
        //getMethodDemo();
        //putMethodDemo();
        //removerMethodDemo();
        //replaceMethodDemo();
        iteratingMapDemo();
    }

    private static void iteratingMapDemo() {
        HashMap<Integer, String> nameMap = new HashMap<>();
        nameMap.put(1, "John");
        nameMap.put(2, "Jack");

        System.out.println("Iterating by using Entry and entrySet()");

        for (Map.Entry<Integer, String> entry : nameMap.entrySet())
            System.out.println("Key = " + entry.getKey() + ", Value = " + entry.getValue());

        System.out.println("Iterating over keys using For-Each loop");
        for (Integer key : nameMap.keySet())
            System.out.println("Key = " + key + ", Value = " + nameMap.get(key));

        System.out.println("Iterating over values using For-Each loop");
        for (String value : nameMap.values())
            System.out.println("Value = " + value);

        System.out.println("Iterating using Iterator");
        Iterator<Map.Entry<Integer, String>> entries = nameMap.entrySet().iterator();
        while (entries.hasNext()) {
            Map.Entry<Integer, String> entry = entries.next();
            System.out.println("Key = " + entry.getKey() + ", Value = " + entry.getValue());
        }

        System.out.println("Iterating over keys and searching for values");
        for (Integer key : nameMap.keySet()) {
            String value = nameMap.get(key);
            System.out.println("Key = " + key + ", Value = " + value);
        }

        System.out.println("Iterating by java8 foreach");
        nameMap.forEach((k, v) -> System.out.println("Item : " + k + " Count : " + v));

    }

    private static void replaceMethodDemo() {
        HashMap<Integer, String> nameMap = new HashMap<>();
        nameMap.put(1, "John");
        nameMap.put(2, "Jack");
        System.out.println("Initial map: " + nameMap);

        System.out.println("Replacing value of entry with key 1 with Steve in map: " + nameMap);
        nameMap.replace(1, "Steve");
        System.out.println("Updated map: " + nameMap);

        System.out.println("Replacing value of entry with key 1 value Steve with John in map: " + nameMap);
        nameMap.replace(1, "Steve", "John");
        System.out.println("Updated map: " + nameMap);

        System.out.println("Replacing value of entry with key 1 value John1 with John in map: " + nameMap);
        nameMap.replace(1, "John1", "Steve");
        System.out.println("Updated map: " + nameMap);

        System.out.println("Replacing value of all entries original value plus \"Smith\": " + nameMap);
        nameMap.replaceAll((key, val) -> val.concat(" Smith"));
        System.out.println("Updated map: " + nameMap);
    }

    private static void removerMethodDemo() {
        HashMap<Integer, String> nameMap = new HashMap<>();
        nameMap.put(1, "John");
        nameMap.put(2, "Jack");
        nameMap.put(3, "Steve");
        nameMap.put(4, "Alex");
        System.out.println("Initial map: " + nameMap);

        System.out.println("Removing entry with key 1");
        nameMap.remove(1);
        System.out.println("Updated map: " + nameMap);

        //Since no key value pair matches no action will be taken
        System.out.println("Removing entry with key 3 and value Steve1");
        nameMap.remove(3, "Steve1");
        System.out.println("Updated map: " + nameMap);

        //Since key value pair matches it will remove corresponding entry from map
        System.out.println("Removing entry with key 3 and value Steve");
        nameMap.remove(3, "Steve");
        System.out.println("Updated map: " + nameMap);
    }

    private static void putMethodDemo() {

        HashMap<Integer, String> nameMap = new HashMap<>();
        nameMap.put(1, "John");

        System.out.println("Initial map: " + nameMap);

        System.out.println("Adding element key 2 and value Jack");
        nameMap.put(2, "Jack");
        System.out.println("Updated map: " + nameMap);

        System.out.println("Adding element key 2 and value Jack1 if key 2 is absent");
        nameMap.putIfAbsent(2, "Jack");
        System.out.println("Updated map: " + nameMap);

        System.out.println("Adding element key 3 and value Steve if key 2 is absent");
        nameMap.putIfAbsent(3, "Steve");
        System.out.println("Updated map: " + nameMap);

        HashMap<Integer, String> anotherNameMap = new HashMap<>();
        anotherNameMap.put(4, "Alex");

        System.out.println("Adding map " + anotherNameMap + " to map " + nameMap);
        nameMap.putAll(anotherNameMap);

        System.out.println("Updated map: " + nameMap);
    }

    private static void getMethodDemo() {
        HashMap<Integer, String> nameMap = new HashMap<>();
        nameMap.put(1, "John");
        nameMap.put(2, "Jack");

        //Since value for key 1 is present in map so get() returns its value
        System.out.println("value for key 1 in map(" + nameMap + " is : " + nameMap.get(1));
        //Since value for key 3 is not present in map so get() returns null
        System.out.println("value for key 3 in map(" + nameMap + " is : " + nameMap.get(3));

        //Since value for key 1 is present in map so getOrDefault() returns its value
        System.out.println("value for key 1 in map(" + nameMap + " is present in map and value is: " + nameMap.getOrDefault(1, "Steve"));
        //Since value for key 1 is present in map so getOrDefault() returns default value
        System.out.println("value for key 3 in map(" + nameMap + " is not present so default value is: " + nameMap.getOrDefault(3, "Steve"));

    }

    private static void containsMethodDemo() {
        HashMap<Integer, String> nameMap = new HashMap<>();
        nameMap.put(1, "John");
        nameMap.put(2, "Jack");
        //returns true because key 1 is present in map
        System.out.println("Is key 1 present in map(" + nameMap + "? : " + nameMap.containsKey(1));
        //returns false because key 3 is not present in map
        System.out.println("Is key 3 present in map(" + nameMap + "? : " + nameMap.containsKey(3));

        //returns true because value John is present in map
        System.out.println("Is value John present in map(" + nameMap + "? : " + nameMap.containsValue("John"));
        //returns false because value Steve is not present in map
        System.out.println("Is value Steve present in map(" + nameMap + "? : " + nameMap.containsValue("Steve"));
    }

    private static void computeMethodDemo() {

        HashMap<Integer, String> nameMap = new HashMap<>();
        nameMap.put(1, "John");
        nameMap.put(2, "Jack");

        System.out.println("Initial map: " + nameMap);

        nameMap.compute(1, (key, val) -> val.concat(" Smith"));
        System.out.println("Map after re evaluating the value for key 1: " + nameMap);
        // will throw NullPointerException because key is not present
        //nameMap.compute(3, (key, val) -> val.concat(" Smith"));
        System.out.println(nameMap);

        //Since key 4 is not present it will get inserted with key 4 and value Steve
        nameMap.computeIfAbsent(4, key -> "Steve");
        System.out.println("Map after re evaluating the value for key 4 if it is absent: " + nameMap);
        //Since key 1 is present it will not get inserted
        nameMap.computeIfAbsent(1, key -> "Steve");
        System.out.println("Map after re evaluating the value for key 1 if it is absent: " + nameMap);

        //Since key 4 is present its value will get calculated as per mapping function
        nameMap.computeIfPresent(4, (key, val) -> val.concat(" Smith"));
        System.out.println("Map after re evaluating the value for key 1 if it is Present: " + nameMap);
        //Since key 5 is not present so its value will not get calculated
        nameMap.computeIfPresent(5, (key, val) -> val.concat(" Smith"));
        System.out.println("Map after re evaluating the value for key 1 if it is Present: " + nameMap);
    }
}
