package com.javacodegeeks.examples.hashmap;

import java.util.*;
import java.util.Map.Entry;

public class HashMapTest {

    public static void main(String[] args) {

        // a simple hashMap declaration with default size and load factor
        HashMap hashMap = new HashMap();
        // hashMap with multiple values with default size and load factor
        HashMap<String, ArrayList> multiMap = new HashMap<String, ArrayList>();

        // Put elements to the hashMap
        hashMap.put("USA", new Integer(1));
        hashMap.put("UK", new Integer(2));
        hashMap.put("China",new Integer(3));

        // take a value of a specific key
        System.out.println("Simple HashMap: Key 'UK' has value = " + hashMap.get("UK"));

        // see if a specific value or key is into the hashMap
        System.out.println("Simple HashMap containes value '1' - " + hashMap.containsValue(1));
        System.out.println("Simple HashMap containes key 'Greece' - "
                + hashMap.containsKey("Greece"));

        // create an arrayList to store values
        ArrayList listOne = new ArrayList();
        listOne.add("Blue");
        listOne.add("Black");
        listOne.add("Brown");

        // create list two and store values
        ArrayList listTwo = new ArrayList();
        listTwo.add("Pink");
        listTwo.add("Purple");

        // put values into map
        multiMap.put("B color", listOne);
        multiMap.put("P color", listTwo);

        // Get a set of the entries
        Set<Entry<String, ArrayList>> setMap = multiMap.entrySet();
        // Get an iterator
        Iterator<Entry<String, ArrayList>> iteratorMap = setMap.iterator();

        System.out.println("\nHashMap with Multiple Values");
        // display all the elements
        while(iteratorMap.hasNext()) {
            Map.Entry<String, ArrayList> entry =
                    (Map.Entry<String, ArrayList>) iteratorMap.next();
            String key = entry.getKey();
            List values = entry.getValue();
            System.out.println("Key = '" + key + "' has values: " + values);
        }

    }
}