package com.javacodegeeks.examples;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;

public class UserInputUsingBufferedReader {

	public static void main(String[] args) {
		System.out.println("Enter your details"); 
		BufferedReader reader = null;
		
		try {
			reader = new BufferedReader(new InputStreamReader(System.in)); // Instantiation
			
			System.out.print("Name : ");    
			String name = reader.readLine();   // Reads complete input token as String
			System.out.println("Name : " + name);           
			
			System.out.print("Age : ");  
			int i = Integer.parseInt(reader.readLine());  // Parses input as a primitive integer
			System.out.println("Age : " + i);  
			
			System.out.print("Salary : ");  
			double d = Double.parseDouble(reader.readLine());  // Parses input as a primitive double
			System.out.println("Salary :: " + d);   
			
			System.out.print("Married : ");
			boolean isMarried = Boolean.parseBoolean(reader.readLine()); // Parses input character as a primitive boolean
			System.out.println("Married : " + isMarried);
		
		} catch (Exception ex) {
			ex.printStackTrace();
		} finally {
			try {
				reader.close();
			} catch (IOException e) {
			}
		}
	}
}
