package jcg.zheng.demo;

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertTrue;

import java.util.ArrayList;

import org.junit.Before;
import org.junit.Test;
import org.slf4j.LoggerFactory;

public class ArrayList_StringTest extends ListBase_StringTest {

	@SuppressWarnings("unchecked")
	@Test
	public void ArrayList_clone() {
		ArrayList<String> arrList = (ArrayList<String>) listItems;
		arrList.add("Mary");
		arrList.add("JCG");

		ArrayList<String> cloneArr = (ArrayList<String>) arrList.clone();
		assertEquals(2, cloneArr.size());
	}

	@Before
	public void setup_list_with_4_items() {
		logger = LoggerFactory.getLogger(this.getClass());

		colItems = new ArrayList<String>();
		assertTrue(colItems.isEmpty());

		colItems.add("Item1");
		assertEquals(1, colItems.size());
		colItems.add("Item2");
		assertEquals(2, colItems.size());
		colItems.add("Item3");
		assertEquals(3, colItems.size());
		colItems.add("Item4");
		assertEquals(4, colItems.size());

		listItems = new ArrayList<String>();
		listItems.addAll(colItems);
		assertEquals(4, listItems.size());
		listItems.clear();

	}

}
