package jcg.zheng.demo;

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertFalse;
import static org.junit.Assert.assertTrue;

import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;

import org.junit.After;
import org.junit.FixMethodOrder;
import org.junit.Test;
import org.junit.runners.MethodSorters;
import org.slf4j.Logger;

@FixMethodOrder(MethodSorters.NAME_ASCENDING)
public abstract class CollectionBase_StringTest {

	protected Collection<String> colItems;

	protected Logger logger;

	@Test
	public void Collection_add() {
		colItems.add("new Item");
		assertEquals(5, colItems.size());

		logger.info("The arraycolItems contains the following elements: " + colItems);
	}

	@After
	public void Collection_clear() {
		colItems.clear();
		assertTrue(colItems.isEmpty());
	}

	@Test
	public void Collection_contains() {
		assertTrue(colItems.contains("Item1"));
		assertFalse(colItems.contains("Item5"));
	}

	@Test
	public void Collection_getSize() {
		assertEquals(4, colItems.size());
	}

	@Test
	public void Collection_isEmpty() {
		assertFalse(colItems.isEmpty());
	}

	@Test
	public void Collection_loop_via_for() {
		logger.info("Retrieving items using for loop");
		for (String str : colItems) {
			logger.info("Item is: " + str);
		}
	}

	@Test
	public void Collection_loop_via_foreach_java8() {
		logger.info("Retrieving items using Java 8 Stream");
		colItems.forEach((item) -> {
			logger.info(item);
		});
	}

	@Test
	public void Collection_loop_via_iterator_next() {
		logger.info("Retrieving items using iterator");
		for (Iterator<String> it = colItems.iterator(); it.hasNext();) {
			logger.info("Item is: " + it.next());
		}
	}

	@Test
	public void Collection_loop_via_iterator_while() {
		Iterator<String> it = colItems.iterator();
		logger.info("Retrieving items using iterator");
		while (it.hasNext()) {
			logger.info("Item is: " + it.next());
		}
	}

	@Test
	public void Collection_remove() {
		boolean removed = colItems.remove("Item1");
		assertTrue(removed);
		assertEquals(3, colItems.size());

		colItems.remove("Item3");
		assertEquals(2, colItems.size());
	}

	@Test
	public void Collection_remove_via_iterator_remove() {
		logger.info("Removing items using iterator");
		for (Iterator<String> it = colItems.iterator(); it.hasNext();) {
			String item = it.next();
			logger.info("Item is: " + item);
			it.remove();
			assertFalse(colItems.contains(item));
		}

		assertTrue(colItems.isEmpty());
	}

	@Test
	public void Collection_toArray_default_java11() {
		String[] simpleArray = colItems.toArray(new String[colItems.size()]);
		logger.info("The array created after the conversion of our arraycolItems is: " + Arrays.toString(simpleArray));

		String[] testArr = colItems.toArray(size -> new String[size]);
		logger.info("default toArray(intfunction):" + Arrays.toString(testArr));
	}
}