package jcg.zheng.demo;

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertTrue;

import java.util.LinkedList;

import org.junit.Before;
import org.junit.Test;
import org.slf4j.LoggerFactory;

public class LinkedList_StringTest extends ListBase_StringTest {

	@Test
	public void DeQue_peekFirst_peekLast() {
		LinkedList<String> linkedLst = (LinkedList<String>) listItems;
		linkedLst.add("Mary");
		linkedLst.add("Zheng");

		assertEquals("Mary", linkedLst.peekFirst());
		assertEquals("Zheng", linkedLst.peekLast());

		assertEquals("Mary", linkedLst.peek());
	}

	@Test
	public void DeQue_peek() {
		LinkedList<String> linkedLst = (LinkedList<String>) listItems;
		linkedLst.add("Mary");
		linkedLst.add("Zheng");

		assertEquals("Mary", linkedLst.peek());
	}

	@Before
	public void setup_colItems_with_4_items() {
		logger = LoggerFactory.getLogger(this.getClass());

		colItems = new LinkedList<String>();
		assertTrue(colItems.isEmpty());

		colItems.add("Item1");
		assertEquals(1, colItems.size());
		colItems.add("Item2");
		assertEquals(2, colItems.size());
		colItems.add("Item3");
		assertEquals(3, colItems.size());
		colItems.add("Item4");
		assertEquals(4, colItems.size());

		listItems = new LinkedList<String>();
		listItems.addAll(colItems);
		assertEquals(4, listItems.size());
		listItems.clear();
	}

}
