package jcg.zheng.demo;

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertTrue;

import java.util.Stack;

import org.junit.Before;
import org.junit.Test;
import org.slf4j.LoggerFactory;

public class Stack_StringTest extends ListBase_StringTest {

	@Before
	public void setup_colItems_with_4_items() {
		logger = LoggerFactory.getLogger(this.getClass());

		colItems = new Stack<String>();
		assertTrue(colItems.isEmpty());

		colItems.add("Item1");
		assertEquals(1, colItems.size());
		colItems.add("Item2");
		assertEquals(2, colItems.size());
		colItems.add("Item3");
		assertEquals(3, colItems.size());
		colItems.add("Item4");
		assertEquals(4, colItems.size());

		listItems = new Stack<String>();
		listItems.addAll(colItems);
		assertEquals(4, listItems.size());
		listItems.clear();
	}

	@Test
	public void Stack_pop() {
		((Stack<String>) listItems).push("Mary");
		String item = ((Stack<String>) listItems).pop();
		assertEquals("Mary", item);
	}

	@Test
	public void Stack_push() {
		((Stack<String>) listItems).push("newValue");
		assertEquals(1, listItems.size());
	}

}
