package jcg.zheng.demo;

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertTrue;

import java.util.Set;
import java.util.TreeSet;

import org.junit.Before;
import org.junit.Test;
import org.slf4j.LoggerFactory;

import jcg.zheng.demo.data.SomeData;

public class TreeSet_POJOTest extends CollectionBase_POJOTest {

	@Test
	public void Set_no_duplicate_ordered() {
		Set<SomeData> testSet = new TreeSet<>();

		testSet.add(buildSomeData(1, "Tom"));
		testSet.add(buildSomeData(3, "Mary"));
		testSet.add(buildSomeData(2, "Shan"));
		testSet.add(buildSomeData(2, "Shan"));
		testSet.add(buildSomeData(4, "Zheng"));
		assertEquals(4, testSet.size());

		logger.info("TreeSet is ordered");
		testSet.forEach(item -> {
			logger.info(item.toString());
		});

	}

	@Before
	public void setup_with_4_items() {
		logger = LoggerFactory.getLogger(this.getClass());

		list = new TreeSet<SomeData>();
		assertTrue(list.isEmpty());

		list.add(buildSomeData(1, "Item1"));
		assertEquals(1, list.size());
		list.add(buildSomeData(2, "Item2"));
		assertEquals(2, list.size());
		list.add(buildSomeData(3, "Item3"));
		assertEquals(3, list.size());
		list.add(buildSomeData(4, "Item4"));
		assertEquals(4, list.size());
	}

}
