package jcg.zheng.demo;

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertTrue;

import java.util.Vector;

import org.junit.Before;
import org.junit.Test;
import org.slf4j.LoggerFactory;

public class Vector_StringTest extends ListBase_StringTest {

	@Before
	public void setup_colItems_with_4_items() {
		logger = LoggerFactory.getLogger(this.getClass());

		colItems = new Vector<String>();
		assertTrue(colItems.isEmpty());

		colItems.add("Item1");
		assertEquals(1, colItems.size());
		colItems.add("Item2");
		assertEquals(2, colItems.size());
		colItems.add("Item3");
		assertEquals(3, colItems.size());
		colItems.add("Item4");
		assertEquals(4, colItems.size());

		listItems = new Vector<String>();
		listItems.addAll(colItems);
		assertEquals(4, listItems.size());
		listItems.clear();
	}

	@Test
	public void Vector_firstElement_lastElement() {
		Vector<String> vectorObj = (Vector<String>) listItems;

		vectorObj.add("Mary");
		vectorObj.add("Zheng");
		assertEquals("Mary", vectorObj.firstElement());
		assertEquals("Zheng", vectorObj.lastElement());
	}

}
