package jcg.zheng.multithread.demo.thread;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;

import jcg.zheng.multithread.demo.CommonUtil;

public class ExecutorServiceExample {

	public static void main(String[] args) {
		System.out.println(Thread.currentThread().getName() + CommonUtil.THREAD_STARTED);

		ExecutorService service = Executors.newFixedThreadPool(5);

		for (int i = 0; i < 5; i++) {
			service.submit(new RunnableThreadExample());
		}

		service.submit(() -> {
			System.out.println(Thread.currentThread().getName() + " is reused");
		});

		try {

			// Executor must be stopped explicitly otherwise it keeps listens for new
			// tasks
			service.shutdown();
			service.awaitTermination(10l, TimeUnit.SECONDS);

		} catch (InterruptedException e) {
			e.printStackTrace();
		} finally {

			System.out.println(Thread.currentThread().getName() + " isTerminated = " + service.isTerminated());
			service.shutdownNow();
		}
		System.out.println(Thread.currentThread().getName() + CommonUtil.THREAD_FINISHED);

	}

}
