package jcg.zheng.multithread.demo.thread;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.ReentrantLock;

public class RaceConditionExample {

	private int count = 0;

	public int getCount() {
		return count;
	}

	AtomicInteger atomicCount = new AtomicInteger();
	public int getCountViaAtomicInteger() {
		count = atomicCount.incrementAndGet();
		return count;
	}

	public void increment() {
		count++;
	}

	public synchronized void incrementSyncMethod() {
		count++;
	}

	public void incrementSyncBlock() {
		synchronized (this) {
			count++;
		}
	}

	// mutual exclusion, same as synchronized
	ReentrantLock lock = new ReentrantLock();
	public void incrementLock() {
		lock.lock();
		try {
			count++;
		} finally {
			lock.unlock();
		}
	}

	public void raceConditionDemo(String type) {
		ExecutorService executor = Executors.newFixedThreadPool(5);
		for (int i = 0; i < 10000; i++) {
			switch (type) {
			case "RaceCondition":
				executor.submit(this::increment);
				break;
			case "Lock":
				executor.submit(this::incrementLock);
				break;
			case "SynchronizedBlock":
				executor.submit(this::incrementSyncBlock);
				break;
			case "SynchronizedMethod":
				executor.submit(this::incrementSyncMethod);
				break;
			case "AtomicInteger":
				executor.submit(this::getCountViaAtomicInteger);
				break;
			}
		}

		try {
			executor.awaitTermination(10l, TimeUnit.SECONDS);
		} catch (InterruptedException e) {
			e.printStackTrace();
		}
		executor.shutdown();
	}

	public static void main(String[] args) {
		RaceConditionExample rE = new RaceConditionExample();
		rE.raceConditionDemo(args[0]);
		System.out.println("Count = " + rE.getCount());
	}
}
