package jcg.zheng.multithread.demo.thread;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import jcg.zheng.multithread.demo.CommonUtil;

public class RunnableThreadExample implements Runnable {

	private Logger logger = LoggerFactory.getLogger(this.getClass());

	@Override
	public void run() {
		logger.info(CommonUtil.THREAD_STARTED);
		CommonUtil.fiveSecondsProcess();
		logger.info(CommonUtil.THREAD_FINISHED);
	}

	public static void main(String[] args) {
		System.out.println(Thread.currentThread().getName() + CommonUtil.THREAD_STARTED);

		Thread thread = new Thread(new RunnableThreadExample());
		System.out.println(Thread.currentThread().getName() + CommonUtil.THREAD_STATE + thread.getState());

		thread.start();
		System.out.println(Thread.currentThread().getName() + CommonUtil.THREAD_STATE + thread.getState());
		if (args.length == 1 && args[0].equalsIgnoreCase("wait")) {
			System.out.println("Wait!");
			CommonUtil.waitForThread(thread);
		}
		System.out.println(Thread.currentThread().getName() + CommonUtil.THREAD_FINISHED);
	}

}
