package jcg.zheng.multithread.demo.thread;

import java.util.concurrent.ThreadFactory;

import jcg.zheng.multithread.demo.CommonUtil;

public class ThreadFactoryExample implements ThreadFactory {

	public static void main(String[] args) {
		System.out.println(Thread.currentThread().getName() + CommonUtil.THREAD_STARTED);

		ThreadFactoryExample tFactory = new ThreadFactoryExample("MZhengThreadFactory");
		for (int i = 0; i < 5; i++) {
			Thread thread = tFactory.newThread(new ThreadExample());
			thread.start();
		}
		System.out.println(Thread.currentThread().getName() + CommonUtil.THREAD_FINISHED);
	}

	private int threadId;

	private String threadName;

	public ThreadFactoryExample(String name) {
		threadId = 1;
		this.threadName = name;
	}

	@Override
	public Thread newThread(Runnable r) {
		Thread thread = new Thread(r, threadName + "-Thread_" + threadId);
		threadId++;
		return thread;
	}

}
