package jcg.zheng.multithread.demo.thread;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import jcg.zheng.multithread.demo.CommonUtil;

public class ThreadNotifyWaitExample extends Thread {

	private static final class ThreadPrintOdd extends Thread {
		private final ThreadNotifyWaitExample tExample;

		private ThreadPrintOdd(ThreadNotifyWaitExample tExample) {
			this.tExample = tExample;
		}

		@Override
		public void run() {
			try {
				tExample.printOdd();
			} catch (InterruptedException e) {
				e.printStackTrace();
			}
		}
	}

	public static void main(String[] args) {
		System.out.println(Thread.currentThread().getName() + CommonUtil.THREAD_STARTED);

		ThreadNotifyWaitExample tExample = new ThreadNotifyWaitExample();

		Thread oddThread = new ThreadPrintOdd(tExample);
		Thread evenThreadJdk8 = new Thread(printEven(tExample));

		oddThread.start();
		evenThreadJdk8.start();

		System.out.println(Thread.currentThread().getName() + CommonUtil.THREAD_FINISHED);

	}

	private static Runnable printEven(ThreadNotifyWaitExample tExample) {
		return () -> {
			try {
				tExample.printEven();
			} catch (InterruptedException e) {
				e.printStackTrace();
			}
		};
	}

	private Logger logger = LoggerFactory.getLogger(this.getClass());

	public synchronized void printEven() throws InterruptedException {
		for (int i = 0; i < 10; i++) {
			if (i % 2 == 0) {
				this.notify();
				logger.info("Even: " + i);
			} else {
				this.wait();
			}
		}
	}

	public synchronized void printOdd() throws InterruptedException {
		for (int i = 0; i < 10; i++) {
			if (i % 2 == 0) {
				this.wait();
			} else {
				this.notify();
				logger.info("Odd: " + i);
			}
		}
	}

}
