package jcg.zheng.multithread.demo.thread;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import jcg.zheng.multithread.demo.CommonUtil;

public class ThreadPriorityExample extends Thread {

	private Logger logger = LoggerFactory.getLogger(this.getClass());

	public void run() {
		logger.info(CommonUtil.THREAD_STARTED);
		logger.info("Running Thread Priority: " + Thread.currentThread().getPriority());
		CommonUtil.fiveSecondsProcess();
		logger.info(CommonUtil.THREAD_FINISHED);
	}

	public static void main(String[] args) {
		System.out.println(Thread.currentThread().getName() + CommonUtil.THREAD_STARTED);

		/* Thread Priority */
		ThreadPriorityExample minThread = new ThreadPriorityExample();
		minThread.setName("Thread1_MIN_PRIORITY");
		minThread.setPriority(Thread.MIN_PRIORITY);

		ThreadPriorityExample maxThread = new ThreadPriorityExample();
		maxThread.setName("Thread2_MAX_PRIORITY");
		maxThread.setPriority(Thread.MAX_PRIORITY);

		ThreadPriorityExample thread3 = new ThreadPriorityExample();
		thread3.setName("Thread3");

		System.out.println(Thread.currentThread().getName() + " starts with min, max, default priority order");
		minThread.start();
		maxThread.start();
		thread3.start();

		System.out.println(Thread.currentThread().getName() + CommonUtil.THREAD_FINISHED);
	}

}