package jcg.zheng.multithread.demo.thread;

import static org.junit.Assert.assertEquals;

import java.lang.Thread.State;

import org.junit.Test;

import jcg.zheng.multithread.demo.CommonUtil;

public class ThreadTestBase {

	Thread thread;

	@Test
	public void create_start_finish() {
		assertEquals(State.NEW, thread.getState());

		assertEquals(State.NEW, thread.getState());

		thread.start();
		assertEquals(State.RUNNABLE, thread.getState());

		CommonUtil.waitForThread(thread);

		assertEquals(State.TERMINATED, thread.getState());
	}

	@Test(expected = IllegalThreadStateException.class)
	public void throw_exception_start_twice() {
		thread.start();
		thread.start();
	}

}