package com.javacodegeeks.examples.comparable;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class ComparatorDemo {
    public static void main(String[] args) {
        employeeNameComparetorDemo();
        employeeSalaryComparetorDemo();
    }

    private static void employeeSalaryComparetorDemo() {
//Sorting array of Employee objects by their salary using Arrays.sort()
Employee[] employees = {new Employee(1, "Pat", 1000.0),
        new Employee(2, "Lesa", 2500.0),
        new Employee(3, "Jackie", 1500.0),
        new Employee(4, "Charles", 6000.0)};
System.out.println("Employee array before sorting: " + Arrays.toString(employees));
Arrays.sort(employees, new EmployeeSalaryComparator());
System.out.println("Employee array after sorting by salary: " + Arrays.toString(employees));

//Sorting List of Employee objects by their salary Collections.sort()
List<Employee> employeeList = Arrays.asList(new Employee(1, "Pat", 1000.0),
        new Employee(2, "Lesa", 2500.0),
        new Employee(3, "Jackie", 1500.0),
        new Employee(4, "Charles", 6000.0));
System.out.println("Employee list before sorting: " + employeeList);
Collections.sort(employeeList, new EmployeeSalaryComparator());
System.out.println("Employee list after sorting by salary: " + employeeList);
    }

    private static void employeeNameComparetorDemo() {
//Sorting array of Employee objects by their name using Arrays.sort()
Employee[] employees = {new Employee(1, "Pat", 1000.0),
        new Employee(2, "Lesa", 2500.0),
        new Employee(3, "Jackie", 1500.0),
        new Employee(4, "Charles", 6000.0)};
System.out.println("Employee array before sorting: " + Arrays.toString(employees));
Arrays.sort(employees, new EmployeeNameComparator());
System.out.println("Employee array after sorting by name: " + Arrays.toString(employees));

//Sorting List of Employee objects by their name Collections.sort()
List<Employee> employeeList = Arrays.asList(new Employee(1, "Pat", 1000.0),
        new Employee(2, "Lesa", 2500.0),
        new Employee(3, "Jackie", 1500.0),
        new Employee(4, "Charles", 6000.0));
System.out.println("Employee list before sorting: " + employeeList);
Collections.sort(employeeList, new EmployeeNameComparator());
System.out.println("Employee list after sorting by name: " + employeeList);


    }
}
