package com.javacodegeeks.examples.stack;

import java.util.Iterator;
import java.util.ListIterator;
import java.util.Stack;

public class StackDemo {
    public static void main(String[] args) {
        creatingStackDemo();
        pushElementToStack();
        popElementFromStack();
        emptyStackException();
        peekElementDemo();
        searchMethDemo();
        iteratingStackDemo();
    }

    private static void searchMethDemo() {
        Stack<String> stackOfBooks = new Stack();
        stackOfBooks.push("Book 1");
        stackOfBooks.push("Book 2");
        System.out.println("Top of the stack is pointing to : " + stackOfBooks.peek());
        System.out.println("Index of  Book 2 into  the stack is : " + stackOfBooks.search("Book 2"));
        System.out.println("Index of  Book 4 into  the stack is : " + stackOfBooks.search("Book 4"));
    }


    private static void peekElementDemo() {
        Stack<String> stackOfBooks = new Stack();
        stackOfBooks.push("Book 1");
        stackOfBooks.push("Book 2");
        System.out.println("Top of the stack is pointing to : " + stackOfBooks.peek());

    }

    private static void emptyStackException() {
        // Creating empty stack
        Stack stackOfBooks = new Stack();

        // pop operation on empty stack. It leads to java.util.EmptyStackException
        stackOfBooks.pop();
    }

    private static void popElementFromStack() {
        // Creating empty stack
        Stack stackOfBooks = new Stack();
        // pushing elements into stack
        stackOfBooks.push("Book 1");
        stackOfBooks.push("Book 2");
        System.out.println("Initial Stack: " + stackOfBooks);
        //removing top element from stack
        stackOfBooks.pop();
        System.out.println("Updated Stack: " + stackOfBooks);
        //removing top element from stack
        stackOfBooks.pop();
        System.out.println("Updated Stack: " + stackOfBooks);
    }

    private static void pushElementToStack() {
        Stack<String> stackOfBooks = new Stack();
        stackOfBooks.push("Book 1");
        stackOfBooks.push("Book 2");
    }

    private static void creatingStackDemo() {
        Stack<String> stackOfBooks = new Stack();
    }


    private static void iteratingStackDemo() {
        Stack<String> stackOfBooks = new Stack<>();

        stackOfBooks.add("Book 1");
        stackOfBooks.add("Book 2");
        stackOfBooks.add("Book 3");
        stackOfBooks.add("Book 4");

//Iterate over a Stack using Java 8 forEach() method
        System.out.println("Iterate over a Stack using Java 8 forEach() method");
        stackOfBooks.forEach(book -> {
            System.out.println(book);
        });

//Iterate over a Stack using iterator()
        System.out.println("Iterate over a Stack using iterator()");
        Iterator<String> booksIterator = stackOfBooks.iterator();
        while (booksIterator.hasNext()) {
            String book = booksIterator.next();
            System.out.println(book);
        }

//Iterate over a Stack using iterator() and Java 8 forEachRemaining() method
        System.out.println("Iterate over a Stack using iterator() and Java 8 forEachRemaining() method");
        booksIterator = stackOfBooks.iterator();
        while (booksIterator.hasNext()) {
            String book = booksIterator.next();
            System.out.println(book);
        }


//Iterate over a Stack from TOP to BOTTOM using listIterator()
        System.out.println("Iterate over a Stack from TOP to BOTTOM using listIterator()");
// ListIterator allows you to traverse in both forward and backward directions.
// We'll start from the top of the stack and traverse backwards.
        ListIterator<String> booksListIterator = stackOfBooks.listIterator(stackOfBooks.size());
        while (booksListIterator.hasPrevious()) {
            String book = booksListIterator.previous();
            System.out.println(book);
        }
    }

    private static void basicStackOperationDemo() {
        // Creating Stack
        Stack stack = new Stack();

        // Adding Stack Element
        stack.push("item1");
        stack.push("item2");
        stack.push("item3");
        System.out.println("Initial stack is: " + stack);

        // Getting top (peek) element
        System.out.println("Top item is: " + stack.peek());

        // Finding 1 based index from top of the stack for an element
        System.out.println("Finding item3: found at index " + stack.search("item1"));

        // Deleting top element
        System.out.println("Deleting top item");
        stack.pop();

        System.out.println("Updated stack is: " + stack);
    }
}
