/* SQL TO CREATE A DATABASE. */ 
CREATE DATABASE IF NOT EXISTS sql_temp_table_example; 

/* USING THE NEWLY CREATED DATABASE. */ 
USE sql_temp_table_example;

/* QUERY 1 = CREATING A TEMPORARY TABLE AND ADDING RECORDS INTO IT. */
CREATE TEMPORARY TABLE cashback(
  id INT AUTO_INCREMENT, 
  customer_id INT NOT NULL, 
  cashback_amount DEC(50, 2), 
  allotted_for_order_id INT NOT NULL, 
  primary key (id)
);

INSERT INTO cashback (customer_id, cashback_amount, allotted_for_order_id) VALUES (205, 30.2, 8312);
INSERT INTO cashback (customer_id, cashback_amount, allotted_for_order_id) VALUES (907, 130.2, 8474);
INSERT INTO cashback (customer_id, cashback_amount, allotted_for_order_id) VALUES (46, 0.2, 3570);

SELECT * FROM cashback;

/* QUERY 2 = CREATING A TEMPORARY COPY OF THE ORIGINAL TABLE AND DISPLAY RESULTS. */
CREATE TEMPORARY TABLE cashback_bkp SELECT * FROM cashback;

SELECT * FROM cashback_bkp;

/* QUERY 3 = DROPPING TEMPORARY TABLE. */
DROP TEMPORARY TABLE cashback;

SELECT * FROM cashback;