/*
 * Decompiled with CFR 0.152.
 */
package org.jcg.zheng;

import java.util.Arrays;
import java.util.concurrent.TimeUnit;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.BenchmarkMode;
import org.openjdk.jmh.annotations.Fork;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.annotations.OutputTimeUnit;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.annotations.Warmup;
import org.openjdk.jmh.runner.Runner;
import org.openjdk.jmh.runner.RunnerException;
import org.openjdk.jmh.runner.options.Options;
import org.openjdk.jmh.runner.options.OptionsBuilder;

@BenchmarkMode(value={Mode.AverageTime})
@OutputTimeUnit(value=TimeUnit.NANOSECONDS)
@State(value=Scope.Benchmark)
@Fork(value=1)
@Warmup(iterations=2)
public class CopyIntArrayBenchmark {
    private int[] sourceIntegerArray = new int[]{1, 2, 3, 4, 5};

    @Benchmark
    public int[] Arrays_int_copyOfRange() {
        return Arrays.copyOfRange(this.sourceIntegerArray, 0, this.sourceIntegerArray.length);
    }

    @Benchmark
    public int[] Arrays_Stream_Int_toArray() {
        return Arrays.stream(this.sourceIntegerArray).toArray();
    }

    @Benchmark
    public int[] clone_IntArray() {
        return (int[])this.sourceIntegerArray.clone();
    }

    @Benchmark
    public int[] System_arraycopy() {
        int[] destination = new int[3];
        System.arraycopy(this.sourceIntegerArray, 0, destination, 0, 3);
        return destination;
    }

    @Benchmark
    public int[] EmptyArray() {
        return new int[0];
    }

    public static void main(String[] args) {
        Options opt = new OptionsBuilder().include(CopyIntArrayBenchmark.class.getSimpleName()).build();
        try {
            new Runner(opt).run();
        }
        catch (RunnerException e) {
            e.printStackTrace();
        }
    }
}

