/*
 * Decompiled with CFR 0.152.
 */
package org.jcg.zheng;

import java.util.Arrays;
import java.util.concurrent.TimeUnit;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.BenchmarkMode;
import org.openjdk.jmh.annotations.Fork;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.annotations.OutputTimeUnit;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.annotations.Warmup;
import org.openjdk.jmh.runner.Runner;
import org.openjdk.jmh.runner.RunnerException;
import org.openjdk.jmh.runner.options.Options;
import org.openjdk.jmh.runner.options.OptionsBuilder;

@BenchmarkMode(value={Mode.AverageTime})
@OutputTimeUnit(value=TimeUnit.NANOSECONDS)
@State(value=Scope.Benchmark)
@Fork(value=1)
@Warmup(iterations=2)
public class CopyStringArrayBenchmark {
    private String[] sourceStringArray = new String[]{"Mary", "Zheng", "Test"};

    @Benchmark
    public String[] Arrays_String_copyOfRange() {
        return Arrays.copyOfRange(this.sourceStringArray, 0, this.sourceStringArray.length);
    }

    @Benchmark
    public String[] Arrays_Stream_String_toArray() {
        return (String[])Arrays.stream(this.sourceStringArray).toArray(String[]::new);
    }

    @Benchmark
    public String[] clone_StringArray() {
        return (String[])this.sourceStringArray.clone();
    }

    @Benchmark
    public String[] System_arraycopy() {
        String[] destination = new String[3];
        System.arraycopy(this.sourceStringArray, 0, destination, 0, 3);
        return destination;
    }

    @Benchmark
    public String[] EmptyArray() {
        return new String[0];
    }

    public static void main(String[] args) {
        Options opt = new OptionsBuilder().include(CopyStringArrayBenchmark.class.getSimpleName()).build();
        try {
            new Runner(opt).run();
        }
        catch (RunnerException e) {
            e.printStackTrace();
        }
    }
}

