package org.jcg.zheng;

public class DemoObject {

    private char charValue;
    private String name;
    private int number;

    public DemoObject(final char charValue, final int number, final String name) {
        super();
        this.charValue = charValue;
        this.name = name;
        this.number = number;
    }

    public DemoObject(DemoObject dObj) {
        if (dObj != null) {
            this.name = dObj.getName();
            this.charValue = dObj.getCharValue();
            this.number = dObj.getNumber();
        }
    }

    public char getCharValue() {
        return charValue;
    }

    public String getName() {
        return name;
    }

    public int getNumber() {
        return number;
    }

    @Override
    public String toString() {
        return "DataObject [number=" + number + ", charValue=" + charValue + ", name=" + name + "]";
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int result = 1;
        result = prime * result + charValue;
        result = prime * result + ((name == null) ? 0 : name.hashCode());
        result = prime * result + number;
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;
        if (getClass() != obj.getClass())
            return false;
        DemoObject other = (DemoObject) obj;
        if (charValue != other.charValue)
            return false;
        if (name == null) {
            if (other.name != null)
                return false;
        } else if (!name.equals(other.name))
            return false;
        if (number != other.number)
            return false;
        return true;
    }

    public void setCharValue(char charValue) {
        this.charValue = charValue;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setNumber(int number) {
        this.number = number;
    }

}
