package org.jcg.zheng;

import static org.junit.Assert.assertEquals;

import java.util.Arrays;

import org.junit.Test;

public class Copy2DIntArrayTest extends TestBase {

	private int[][] clonedArrays;
	private int[][] source2DArray = { { 1, 2, 3, 4, 5 }, { 3, 4 } };

	protected void validate() {
		assertEquals(source2DArray.length, clonedArrays.length);
		assertEquals(source2DArray[0][0], clonedArrays[0][0]);
		assertEquals(source2DArray[0][1], clonedArrays[0][1]);
		assertEquals(source2DArray[1][0], clonedArrays[1][0]);
		assertEquals(source2DArray[1][1], clonedArrays[1][1]);
	}

	@Test
	public void via_Arrays_stream_toArray_lambda() {
		clonedArrays = Arrays.stream(source2DArray).map((int[] row) -> row.clone())
				.toArray((int length) -> new int[length][]);

		validate();
	}

	@Test
	public void via_Arrays_stream_toArray_methodReference() {
		clonedArrays = Arrays.stream(source2DArray).map(int[]::clone).toArray(int[][]::new);
		validate();
	 
	}

	@Test
	public void via_Object_clone() {
		clonedArrays = source2DArray.clone();
		validate();
	}

	@Test
	public void via_System_arraycopy() {
		clonedArrays = new int[source2DArray.length][];
		for (int i = 0; i < source2DArray.length; i++) {
			int[] aSource = source2DArray[i];
			clonedArrays[i] = new int[source2DArray.length];
			System.arraycopy(aSource, 0, clonedArrays[i], 0, source2DArray.length);
		}

		validate();
	}
	
	@Test
	public void via_Arrays_copyOf() {
		clonedArrays = new int[source2DArray.length][];
		for (int i = 0; i < source2DArray.length; i++) {
			int[] aSource = source2DArray[i];	
			clonedArrays[i] = Arrays.copyOf(aSource, aSource.length);
		}

		validate();
	}

}