package org.jcg.zheng;

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertFalse;

import java.util.Arrays;

import org.junit.Test;

public class CopyIntArrayTest extends TestBase {

	private int[] sourceIntegerArray = { 1, 2, 3, 4, 5 };

	private void validate_IntArray(int[] clonedArray) {
		// the copied object is a different reference
		assertFalse(System.identityHashCode(sourceIntegerArray) - System.identityHashCode(clonedArray) == 0);

		// for primitive data type, change the clonedArray element does not affect the
		// source array
		clonedArray[0] = 99;

		assertEquals(99, clonedArray[0]);
		assertEquals(1, sourceIntegerArray[0]);

		sourceIntegerArray[1] = 99;
		assertEquals(2, clonedArray[1]);
	}

	@Test
	public void via_Arrays_copyOf() {
		// since 1.6
		int[] copyofArr = Arrays.copyOf(sourceIntegerArray, sourceIntegerArray.length);

		assertEquals(sourceIntegerArray.length, copyofArr.length);
		validate_IntArray(copyofArr);
	}

	@Test
	public void via_Arrays_copyOf_big() {
		int[] copyofArr = Arrays.copyOf(sourceIntegerArray, sourceIntegerArray.length + 1);

		assertEquals(sourceIntegerArray.length + 1, copyofArr.length);
		assertEquals(0, copyofArr[sourceIntegerArray.length]);
		validate_IntArray(copyofArr);
	}

	@Test
	public void via_Arrays_copyOf_small() {
		int[] copyofArr = Arrays.copyOf(sourceIntegerArray, sourceIntegerArray.length - 1);

		assertEquals(sourceIntegerArray.length - 1, copyofArr.length);
		validate_IntArray(copyofArr);
	}

	@Test
	public void via_Arrays_copyOfRange() {
		// since 1.6
		int[] copyofArr = Arrays.copyOfRange(sourceIntegerArray, copyStartAtZeroIndex, sourceIntegerArray.length);

		assertEquals(sourceIntegerArray.length, copyofArr.length);
		assertEquals(sourceIntegerArray[0], copyofArr[0]);
		assertEquals(sourceIntegerArray[1], copyofArr[1]);
		validate_IntArray(copyofArr);
	}

	@Test
	public void via_Arrays_stream_toArray() {
		// since 1.8
		int[] copyofArr = Arrays.stream(sourceIntegerArray).toArray();

		assertEquals(sourceIntegerArray.length, copyofArr.length);
		assertEquals(1, sourceIntegerArray[0]);
		assertEquals(1, copyofArr[0]);
		validate_IntArray(copyofArr);
	}

	@Test
	public void via_Object_clone() {
		// since 1.0
		int[] clonedArray = sourceIntegerArray.clone();

		assertEquals(sourceIntegerArray.length, clonedArray.length);
		assertEquals(sourceIntegerArray[0], clonedArray[0]);
		assertEquals(sourceIntegerArray[1], clonedArray[1]);
		assertEquals(sourceIntegerArray[2], clonedArray[2]);
		validate_IntArray(clonedArray);
	}

	@Test
	public void via_System_arraycopy() {
		int length = 3;
		int[] destination = new int[length];

		// since 1.0
		System.arraycopy(sourceIntegerArray, copyStartAtZeroIndex, destination, copyStartAtZeroIndex, length);

		assertEquals(length, destination.length);
		assertEquals(sourceIntegerArray[copyStartAtZeroIndex], destination[0]);
		assertEquals(sourceIntegerArray[copyStartAtZeroIndex + 1], destination[1]);
		assertEquals(sourceIntegerArray[copyStartAtZeroIndex + 2], destination[2]);
		validate_IntArray(destination);
	}
}
